/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.crisis;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;

public abstract class AbstractCrisis {
    protected int eventTimer = 0;
    protected int nextTick = 0;

    public final boolean isFinished() {
        return this.eventTimer < 0;
    }

    protected final void scheduleUpdateTick(int n) {
        if (n < 0) {
            ZSSMain.logger.warn("Oops! Scheduling a crisis tick with n less than zero.");
        }
        this.nextTick = n > 0 ? this.eventTimer - n : 0;
    }

    public final void onUpdate(World world) {
        if (this.eventTimer > 0) {
            --this.eventTimer;
            if (this.eventTimer % 20 == 0 && this.canCrisisConclude(world)) {
                this.eventTimer = 0;
            } else if (this.eventTimer < 40) {
                this.eventTimer += 40;
            }
            if (this.eventTimer == 0) {
                this.endCrisis(world);
                this.eventTimer = -1;
            } else if (this.eventTimer == this.nextTick) {
                this.onUpdateTick(world);
            }
        } else {
            ZSSMain.logger.warn("Unexpected timer value: crisis terminated but not handled");
            this.eventTimer = -1;
        }
    }

    protected abstract void onUpdateTick(World var1);

    public abstract void beginCrisis(World var1);

    protected abstract void endCrisis(World var1);

    protected abstract boolean canCrisisConclude(World var1);

    public void writeToNBT(NBTTagCompound compound) {
        compound.setInteger("eventTimer", this.eventTimer);
        compound.setInteger("nextTick", this.nextTick);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.eventTimer = compound.getInteger("eventTimer");
        this.nextTick = compound.getInteger("nextTick");
    }
}

