/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.entity.EntityFairy;
import zeldaswordskills.ref.Config;

public class WorldUtils {
    public static final int MAX_RADIUS = 16;

    public static void activateButton(World world, Block block, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockMetadataWithNotify(x, y, z, meta < 8 ? meta | 8 : meta & 0xFFFFFFF7, 3);
        world.func_147479_m(x, y, z);
        world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        world.scheduleBlockUpdate(x, y, z, block, block.tickRate(world));
        world.notifyBlocksOfNeighborChange(x, y, z, block);
        switch (meta & 7) {
            case 0: 
            case 7: {
                world.notifyBlocksOfNeighborChange(x, y + 1, z, block);
                break;
            }
            case 1: {
                world.notifyBlocksOfNeighborChange(x - 1, y, z, block);
                break;
            }
            case 2: {
                world.notifyBlocksOfNeighborChange(x + 1, y, z, block);
                break;
            }
            case 3: {
                world.notifyBlocksOfNeighborChange(x, y, z - 1, block);
                break;
            }
            case 4: {
                world.notifyBlocksOfNeighborChange(x, y, z + 1, block);
                break;
            }
            default: {
                world.notifyBlocksOfNeighborChange(x, y - 1, z, block);
            }
        }
    }

    public static boolean canMeltBlock(World world, Block block, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        boolean flag = Config.enableFireArrowMelt() ? (meta & 0xFFFFFFF7) == 5 : meta == 5;
        return block.getMaterial() == Material.ice || block.getMaterial() == Material.packedIce || block.getMaterial() == Material.snow || block.getMaterial() == Material.craftedSnow || block == ZSSBlocks.secretStone && flag;
    }

    public static void dropHeldItem(EntityLivingBase entity) {
        if (!entity.worldObj.isRemote && entity.getHeldItem() != null) {
            EntityItem drop = new EntityItem(entity.worldObj, entity.posX, entity.posY - (double)0.3f + (double)entity.getEyeHeight(), entity.posZ, entity.getHeldItem().copy());
            float f = 0.3f;
            float f1 = entity.worldObj.rand.nextFloat() * (float)Math.PI * 2.0f;
            drop.motionX = -MathHelper.sin((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f;
            drop.motionZ = MathHelper.cos((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f;
            drop.motionY = -MathHelper.sin((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f * entity.worldObj.rand.nextFloat();
            drop.motionX += Math.cos(f1) * (double)f;
            drop.motionY += (double)((entity.worldObj.rand.nextFloat() - entity.worldObj.rand.nextFloat()) * 0.1f);
            drop.motionZ += Math.sin(f1) * (double)f;
            drop.delayBeforeCanPickup = 40;
            entity.worldObj.spawnEntityInWorld((Entity)drop);
            entity.setCurrentItemOrArmor(0, (ItemStack)null);
        }
    }

    public static void dropContainerBlockInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inv = (IInventory)tileEntity;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            WorldUtils.spawnItemWithRandom(world, inv.getStackInSlotOnClosing(i), x, y, z);
        }
    }

    public static void generateRandomChestContents(Random rand, WeightedRandomChestContent[] weightedContents, IInventory chest, int numItems, boolean atRandom) {
        for (int i = 0; i < numItems; ++i) {
            ItemStack[] stacks;
            WeightedRandomChestContent weightedChest = (WeightedRandomChestContent)WeightedRandom.getRandomItem((Random)rand, (WeightedRandom.Item[])weightedContents);
            for (ItemStack item : stacks = ChestGenHooks.generateStacks((Random)rand, (ItemStack)weightedChest.theItemId, (int)weightedChest.theMinimumChanceToGenerateItem, (int)weightedChest.theMaximumChanceToGenerateItem)) {
                if (atRandom) {
                    chest.setInventorySlotContents(rand.nextInt(chest.getSizeInventory()), item);
                    continue;
                }
                WorldUtils.addItemToInventoryAtRandom(rand, item, chest, 3);
            }
        }
    }

    public static int addItemToInventoryAtRandom(Random rand, ItemStack stack, IInventory inv, int numAttempts) {
        for (int i = 0; i < numAttempts; ++i) {
            int slot = rand.nextInt(inv.getSizeInventory());
            if (inv.getStackInSlot(slot) != null) continue;
            inv.setInventorySlotContents(slot, stack);
            return 0;
        }
        return WorldUtils.addItemToInventory(stack, inv);
    }

    public static int addItemToInventory(ItemStack stack, IInventory inv) {
        int remaining = stack.stackSize;
        for (int i = 0; i < inv.getSizeInventory() && remaining > 0; ++i) {
            ItemStack slotstack = inv.getStackInSlot(i);
            if (slotstack == null && inv.isItemValidForSlot(i, stack)) {
                stack.stackSize = (remaining -= inv.getInventoryStackLimit()) > 0 ? inv.getInventoryStackLimit() : stack.stackSize;
                inv.setInventorySlotContents(i, stack);
                inv.markDirty();
                continue;
            }
            if (slotstack == null || !stack.isStackable() || !inv.isItemValidForSlot(i, stack) || slotstack.getItem() != stack.getItem() || stack.getHasSubtypes() && stack.getItemDamage() != slotstack.getItemDamage() || !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)slotstack)) continue;
            int l = slotstack.stackSize + remaining;
            if (l <= stack.getMaxStackSize() && l <= inv.getInventoryStackLimit()) {
                remaining = 0;
                slotstack.stackSize = l;
                inv.markDirty();
                continue;
            }
            if (slotstack.stackSize >= stack.getMaxStackSize() || stack.getMaxStackSize() > inv.getInventoryStackLimit()) continue;
            remaining -= stack.getMaxStackSize() - slotstack.stackSize;
            slotstack.stackSize = stack.getMaxStackSize();
            inv.markDirty();
        }
        return remaining;
    }

    public static boolean addInventoryContents(World world, int x, int y, int z, List<ItemStack> items) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            for (ItemStack stack : items) {
                if (WorldUtils.addItemToInventory(stack, inv) <= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean addInventoryContentsRandomly(World world, int x, int y, int z, List<ItemStack> items) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            boolean flag = true;
            for (ItemStack stack : items) {
                if (WorldUtils.addItemToInventoryAtRandom(world.rand, stack, inv, 3) <= 0) continue;
                flag = false;
            }
            return flag;
        }
        return false;
    }

    public static HashSet<ChunkPosition> getAffectedBlocksList(World world, Random rand, float radius, double posX, double posY, double posZ, Block targetBlock) {
        HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double d3 = (float)i / 15.0f * 2.0f - 1.0f;
                    double d4 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d5 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d0 = posX;
                    double d1 = posY;
                    double d2 = posZ;
                    float f2 = 0.3f;
                    for (float f1 = radius * (0.7f + rand.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                        int j1;
                        int i1;
                        int l = MathHelper.floor_double((double)d0);
                        Block block = world.getBlock(l, i1 = MathHelper.floor_double((double)d1), j1 = MathHelper.floor_double((double)d2));
                        if (block.getMaterial() != Material.air) {
                            f1 -= 1.3f * f2;
                        }
                        if (f1 > 0.0f && (targetBlock == null || block == targetBlock)) {
                            hashset.add(new ChunkPosition(l, i1, j1));
                        }
                        d0 += d3 * (double)f2;
                        d1 += d4 * (double)f2;
                        d2 += d5 * (double)f2;
                    }
                }
            }
        }
        return hashset;
    }

    public static <T extends TileEntity> List<T> getTileEntitiesWithinAABB(World world, Class<T> clazz, AxisAlignedBB aabb) {
        int maxZ;
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        int minX = MathHelper.floor_double((double)(aabb.minX - World.MAX_ENTITY_RADIUS));
        int maxX = MathHelper.floor_double((double)(aabb.maxX + World.MAX_ENTITY_RADIUS));
        int minY = MathHelper.floor_double((double)(aabb.minY - World.MAX_ENTITY_RADIUS));
        int maxY = MathHelper.floor_double((double)(aabb.maxY + World.MAX_ENTITY_RADIUS));
        int minZ = MathHelper.floor_double((double)(aabb.minZ - World.MAX_ENTITY_RADIUS));
        if (!world.checkChunksExist(minX, minY, minZ, maxX, maxY, maxZ = MathHelper.floor_double((double)(aabb.maxZ + World.MAX_ENTITY_RADIUS)))) {
            return list;
        }
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minY; j <= maxY; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    TileEntity te = world.getTileEntity(i, j, k);
                    if (te == null || !clazz.isAssignableFrom(te.getClass())) continue;
                    list.add(te);
                }
            }
        }
        return list;
    }

    public static Entity getEntityByUUID(World world, UUID uuid) {
        for (Object o : world.loadedEntityList) {
            if (((Entity)o).getUniqueID().compareTo(uuid) != 0) continue;
            return (Entity)o;
        }
        return null;
    }

    public static TileEntityDungeonCore getNearbyFairySpawner(World world, double x, double y, double z, boolean requiresFairy) {
        List<TileEntityDungeonCore> list = WorldUtils.getTileEntitiesWithinAABB(world, TileEntityDungeonCore.class, AxisAlignedBB.getBoundingBox((double)(x - 3.0), (double)(y - 2.0), (double)(z - 3.0), (double)(x + 3.0), (double)(y + 2.0), (double)(z + 3.0)));
        for (TileEntityDungeonCore core : list) {
            if (!core.isSpawner() || requiresFairy && world.getEntitiesWithinAABB(EntityFairy.class, AxisAlignedBB.getBoundingBox((double)((double)core.xCoord - 5.0), (double)((double)core.yCoord - 1.0), (double)((double)core.zCoord - 5.0), (double)((double)core.xCoord + 5.0), (double)((double)core.yCoord + 5.0), (double)((double)core.zCoord + 5.0))).size() <= 0) continue;
            return core;
        }
        return null;
    }

    public static void playSoundAtEntity(Entity entity, String sound, float f, float add) {
        WorldUtils.playSoundAt(entity.worldObj, entity.posX, entity.posY, entity.posZ, sound, f, add);
    }

    public static void playSoundAt(World world, double x, double y, double z, String sound, float f, float add) {
        float volume = world.rand.nextFloat() * f + add;
        float pitch = 1.0f / (world.rand.nextFloat() * f + add);
        world.playSoundEffect(x, y, z, sound, volume, pitch);
    }

    public static void spawnItemWithRandom(World world, ItemStack stack, double x, double y, double z) {
        WorldUtils.spawnItemWithRandom(world, stack, x, y, z, 0.05f);
    }

    public static void spawnItemWithRandom(World world, ItemStack stack, double x, double y, double z, float motionFactor) {
        if (!world.isRemote && stack != null) {
            double spawnX = x + (double)world.rand.nextFloat();
            double spawnY = y + (double)world.rand.nextFloat();
            double spawnZ = z + (double)world.rand.nextFloat();
            float f = MathHelper.clamp_float((float)motionFactor, (float)0.0f, (float)1.0f);
            EntityItem entityitem = new EntityItem(world, spawnX, spawnY, spawnZ, stack);
            entityitem.motionX = (-0.5 + world.rand.nextGaussian()) * (double)f;
            entityitem.motionY = (4.0 + world.rand.nextGaussian()) * (double)f;
            entityitem.motionZ = (-0.5 + world.rand.nextGaussian()) * (double)f;
            entityitem.delayBeforeCanPickup = 10;
            world.spawnEntityInWorld((Entity)entityitem);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnWorldParticles(World world, EntityFX particle) {
        Minecraft mc = Minecraft.getMinecraft();
        if (particle != null && mc != null && mc.renderViewEntity != null && mc.effectRenderer != null) {
            int particleSetting = mc.gameSettings.particleSetting;
            if (particleSetting == 2 || particleSetting == 1 && world.rand.nextInt(3) == 0) {
                return;
            }
            double dx = mc.renderViewEntity.posX - particle.posX;
            double dy = mc.renderViewEntity.posY - particle.posY;
            double dz = mc.renderViewEntity.posZ - particle.posZ;
            if (dx * dx + dy * dy + dz * dz < 256.0) {
                Minecraft.getMinecraft().effectRenderer.addEffect(particle);
            }
        }
    }

    public static void spawnXPOrbsWithRandom(World world, Random rand, int x, int y, int z, int xpAmount) {
        if (!world.isRemote) {
            while (xpAmount > 0) {
                int xp = xpAmount > 50 ? 50 : EntityXPOrb.getXPSplit((int)xpAmount);
                xpAmount -= xp;
                float spawnX = (float)x + rand.nextFloat();
                float spawnY = (float)y + rand.nextFloat();
                float spawnZ = (float)z + rand.nextFloat();
                EntityXPOrb xpOrb = new EntityXPOrb(world, (double)spawnX, (double)spawnY, (double)spawnZ, xp);
                xpOrb.motionY += (4.0 + rand.nextGaussian()) * (double)0.05f;
                world.spawnEntityInWorld((Entity)xpOrb);
            }
        }
    }

    public static boolean setEntityInStructure(World world, Entity entity, int x, int y, int z) {
        if (entity == null) {
            return false;
        }
        entity.setLocationAndAngles((double)x, (double)y, (double)z, 0.0f, 0.0f);
        block6: for (int i = 0; entity.isEntityInsideOpaqueBlock() && i < 8; ++i) {
            if (i == 4) {
                entity.setPosition((double)(x + 1), (double)y, (double)(z + 1));
            }
            switch (i % 4) {
                case 0: {
                    entity.setPosition(entity.posX + 0.5, entity.posY, entity.posZ + 0.5);
                    continue block6;
                }
                case 1: {
                    entity.setPosition(entity.posX, entity.posY, entity.posZ - 1.0);
                    continue block6;
                }
                case 2: {
                    entity.setPosition(entity.posX - 1.0, entity.posY, entity.posZ);
                    continue block6;
                }
                case 3: {
                    entity.setPosition(entity.posX, entity.posY, entity.posZ + 1.0);
                }
            }
        }
        if (entity.isEntityInsideOpaqueBlock()) {
            entity.setPosition(entity.posX + 0.5, entity.posY, entity.posZ + 0.5);
            return false;
        }
        return true;
    }
}

