/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

public enum SongNote {
    A1_FLAT(Note.A, Pitch.FLAT),
    A1(Note.A, Pitch.NATURAL),
    B1_FLAT(Note.B, Pitch.FLAT),
    B1(Note.B, Pitch.NATURAL),
    C1(Note.C, Pitch.NATURAL),
    C1_SHARP(Note.C, Pitch.SHARP),
    D1(Note.D, Pitch.NATURAL),
    D1_SHARP(Note.D, Pitch.SHARP),
    E1(Note.E, Pitch.NATURAL),
    F1(Note.F, Pitch.NATURAL),
    F1_SHARP(Note.F, Pitch.SHARP),
    G1(Note.G, Pitch.NATURAL),
    G1_SHARP(Note.G, Pitch.SHARP),
    A2(Note.A, Pitch.NATURAL),
    B2_FLAT(Note.B, Pitch.FLAT),
    B2(Note.B, Pitch.NATURAL),
    C2(Note.C, Pitch.NATURAL),
    C2_SHARP(Note.C, Pitch.SHARP),
    D2(Note.D, Pitch.NATURAL),
    D2_SHARP(Note.D, Pitch.SHARP),
    E2(Note.E, Pitch.NATURAL),
    F2(Note.F, Pitch.NATURAL),
    F2_SHARP(Note.F, Pitch.SHARP),
    G2(Note.G, Pitch.NATURAL),
    G2_SHARP(Note.G, Pitch.SHARP);

    public final Note note;
    public final Pitch pitch;

    private SongNote(Note note, Pitch pitch) {
        this.note = note;
        this.pitch = pitch;
    }

    public String toString() {
        return this.note.toString() + this.getOctave() + "-" + this.pitch.toString();
    }

    public int getOctave() {
        return (this.ordinal() - 1) / 12 + 1;
    }

    public boolean isFlat() {
        return this.pitch == Pitch.FLAT;
    }

    public boolean isSharp() {
        return this.pitch == Pitch.SHARP;
    }

    public static SongNote getNote(PlayableNote note, int modifier) {
        modifier = modifier < -3 ? -3 : (modifier > 3 ? 3 : modifier);
        int i = note.note.ordinal() + modifier;
        return i < 0 || i > SongNote.values().length ? null : SongNote.values()[i];
    }

    public static enum Note {
        A,
        B,
        C,
        D,
        E,
        F,
        G;


        public String toString() {
            return this.name();
        }

        public Note prev() {
            return this == A ? G : Note.values()[this.ordinal() - 1];
        }

        public Note next() {
            return this == G ? A : Note.values()[this.ordinal() + 1];
        }
    }

    public static enum Pitch {
        FLAT,
        NATURAL,
        SHARP;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum PlayableNote {
        D1(D1),
        F1(F1),
        A2(A2),
        B2(B2),
        D2(D2);

        protected final SongNote note;

        private PlayableNote(SongNote note) {
            this.note = note;
        }

        public String toString() {
            return this.name();
        }

        public static int getOrdinalFromNote(SongNote note) {
            for (PlayableNote playable : PlayableNote.values()) {
                if (playable.note != note) continue;
                return playable.ordinal();
            }
            return PlayableNote.values().length;
        }
    }
}

