/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.util.UUID;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.shield.IShield;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.item.IWeapon;
import zeldaswordskills.api.item.WeaponRegistry;
import zeldaswordskills.item.ItemZeldaShield;
import zeldaswordskills.item.ItemZeldaSword;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.PlaySoundPacket;

public class PlayerUtils {
    public static final UUID itemDamageUUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");

    public static boolean isBlocking(EntityPlayer player) {
        if (player.isBlocking()) {
            return true;
        }
        if (ZSSMain.isBG2Enabled) {
            return ((IBattlePlayer)player).isBattlemode() && ((IBattlePlayer)player).isBlockingWithShield();
        }
        return false;
    }

    public static boolean isShield(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (ZSSMain.isBG2Enabled && stack.getItem() instanceof IShield) {
            return true;
        }
        return stack.getItem() instanceof ItemZeldaShield;
    }

    public static boolean isHoldingWeapon(EntityPlayer player) {
        AttributeModifier itemDamage = player.getAttributeMap().getAttributeInstance(SharedMonsterAttributes.attackDamage).getModifier(itemDamageUUID);
        return itemDamage != null && itemDamage.getAmount() > 0.0;
    }

    public static boolean isSword(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.getItem() instanceof IWeapon) {
            return ((IWeapon)stack.getItem()).isSword(stack);
        }
        return WeaponRegistry.INSTANCE.isSword(stack.getItem());
    }

    public static boolean isWeapon(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.getItem() instanceof IWeapon) {
            return ((IWeapon)stack.getItem()).isWeapon(stack);
        }
        return PlayerUtils.isSword(stack) || WeaponRegistry.INSTANCE.isWeapon(stack.getItem());
    }

    public static boolean isHoldingZeldaSword(EntityLivingBase entity) {
        return entity.getHeldItem() != null && entity.getHeldItem().getItem() instanceof ItemZeldaSword;
    }

    public static boolean isHoldingMasterSword(EntityLivingBase entity) {
        return PlayerUtils.isHoldingZeldaSword(entity) && ((ItemZeldaSword)entity.getHeldItem().getItem()).isMasterSword();
    }

    public static boolean hasMasterSword(EntityPlayer player) {
        for (ItemStack stack : player.inventory.mainInventory) {
            if (stack == null || !(stack.getItem() instanceof ItemZeldaSword) || !((ItemZeldaSword)stack.getItem()).isMasterSword()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItem(EntityPlayer player, Item item) {
        return PlayerUtils.hasItem(player, item, -1);
    }

    public static boolean hasItem(EntityPlayer player, ItemStack stack) {
        return PlayerUtils.hasItem(player, stack.getItem(), stack.getItemDamage());
    }

    public static boolean hasItem(EntityPlayer player, Item item, int meta) {
        for (ItemStack stack : player.inventory.mainInventory) {
            if (stack == null || stack.getItem() != item || meta != -1 && stack.getItemDamage() != meta) continue;
            return true;
        }
        return false;
    }

    public static float getHealthMissing(EntityPlayer player) {
        return player.capabilities.isCreativeMode ? 0.0f : player.getMaxHealth() - player.getHealth();
    }

    public static void addItemToInventory(EntityPlayer player, ItemStack stack) {
        if (!player.inventory.addItemStackToInventory(stack)) {
            player.dropPlayerItemWithRandomChoice(stack, false);
        } else if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).sendContainerToPlayer(player.openContainer);
        }
    }

    public static boolean consumeHeldItem(EntityPlayer player, Item item, int amount) {
        return PlayerUtils.consumeHeldItem(player, item, -1, amount);
    }

    public static boolean consumeHeldItem(EntityPlayer player, Item item, int damage, int amount) {
        if (amount < 1) {
            return false;
        }
        ItemStack stack = player.getHeldItem();
        if (stack == null || stack.getItem() != item || stack.stackSize < amount) {
            return false;
        }
        if (damage > -1 && stack.getItemDamage() != damage) {
            return false;
        }
        if (player.capabilities.isCreativeMode) {
            return true;
        }
        stack.stackSize -= amount;
        if (stack.stackSize < 1) {
            stack = null;
            player.setCurrentItemOrArmor(0, null);
        }
        return true;
    }

    public static boolean consumeInventoryItem(EntityPlayer player, Item item, int required) {
        return PlayerUtils.consumeInventoryItem(player, item, 0, required);
    }

    public static boolean consumeInventoryItem(EntityPlayer player, ItemStack stack, int required) {
        return PlayerUtils.consumeInventoryItem(player, stack.getItem(), stack.getItemDamage(), required);
    }

    public static boolean consumeInventoryItem(EntityPlayer player, Item item, int meta, int required) {
        if (required < 1) {
            return false;
        }
        int consumed = required;
        for (int i = 0; i < player.inventory.getSizeInventory() && consumed > 0; ++i) {
            ItemStack invStack = player.inventory.getStackInSlot(i);
            if (invStack == null || invStack.getItem() != item || invStack.getItemDamage() != meta) continue;
            if (invStack.stackSize <= consumed) {
                consumed -= invStack.stackSize;
                if (player.capabilities.isCreativeMode) continue;
                player.inventory.setInventorySlotContents(i, null);
                continue;
            }
            if (!player.capabilities.isCreativeMode) {
                invStack = invStack.splitStack(invStack.stackSize - consumed);
                player.inventory.setInventorySlotContents(i, invStack);
            }
            consumed = 0;
        }
        if (consumed > 0 && !player.capabilities.isCreativeMode) {
            player.inventory.addItemStackToInventory(new ItemStack(item, required - consumed, meta));
        }
        return consumed == 0;
    }

    public static void sendTranslatedChat(EntityPlayer player, String message, Object ... args) {
        player.addChatMessage((IChatComponent)new ChatComponentTranslation(message, args));
    }

    public static void playSound(EntityPlayer player, String sound, float volume, float pitch) {
        if (player.worldObj.isRemote) {
            PacketDispatcher.sendToServer(new PlaySoundPacket(sound, volume, pitch, (Entity)player));
        } else if (player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new PlaySoundPacket(sound, volume, pitch), (EntityPlayerMP)player);
        }
    }

    public static void playRandomizedSound(EntityPlayer player, String sound, float f, float add) {
        float volume = player.worldObj.rand.nextFloat() * f + add;
        float pitch = 1.0f / (player.worldObj.rand.nextFloat() * f + add);
        PlayerUtils.playSound(player, sound, volume, pitch);
    }
}

