/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class MerchantRecipeHelper {
    public static boolean doesListContain(MerchantRecipeList trades, MerchantRecipe recipe) {
        if (recipe == null) {
            return true;
        }
        for (int i = 0; i < trades.size(); ++i) {
            if (!MerchantRecipeHelper.areTradesIdentical(recipe, (MerchantRecipe)trades.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSimilarTrade(MerchantRecipeList trades, MerchantRecipe trade) {
        if (trade == null || trades == null) {
            return false;
        }
        for (int i = 0; i < trades.size(); ++i) {
            MerchantRecipe trade1 = (MerchantRecipe)trades.get(i);
            if (!MerchantRecipeHelper.haveSameTradeItems(trade, trade1)) continue;
            return true;
        }
        return false;
    }

    public static boolean addUniqueTrade(MerchantRecipeList trades, MerchantRecipe trade) {
        if (!MerchantRecipeHelper.doesListContain(trades, trade)) {
            trades.add((Object)trade);
            return true;
        }
        return false;
    }

    public static boolean addToListWithCheck(MerchantRecipeList trades, MerchantRecipe trade) {
        return MerchantRecipeHelper.addToListWithCheck(trades, trade, false);
    }

    public static boolean addToListWithCheck(MerchantRecipeList trades, MerchantRecipe trade, boolean replaceExistingTrade) {
        for (int i = 0; i < trades.size(); ++i) {
            MerchantRecipe merchantrecipe1 = (MerchantRecipe)trades.get(i);
            if (!MerchantRecipeHelper.haveSameTradeItems(trade, merchantrecipe1)) continue;
            if (replaceExistingTrade) {
                trades.set(i, (Object)trade);
                return true;
            }
            return false;
        }
        trades.add((Object)trade);
        return true;
    }

    public static boolean removeTrade(MerchantRecipeList trades, MerchantRecipe trade, boolean exactMatch, boolean removeAll) {
        boolean found = false;
        Iterator iterator = trades.iterator();
        while (iterator.hasNext()) {
            MerchantRecipe recipe = (MerchantRecipe)iterator.next();
            if (!(exactMatch ? MerchantRecipeHelper.areTradesIdentical(trade, recipe) : MerchantRecipeHelper.haveSameTradeItems(trade, recipe))) continue;
            iterator.remove();
            if (!removeAll) {
                return true;
            }
            found = true;
        }
        return found;
    }

    public static boolean haveSameTradeItems(MerchantRecipe a, MerchantRecipe b) {
        ItemStack item1a = a.getItemToBuy();
        ItemStack item1b = b.getItemToBuy();
        ItemStack item2a = a.getItemToSell();
        ItemStack item2b = b.getItemToSell();
        ItemStack item3a = a.getSecondItemToBuy();
        ItemStack item3b = b.getSecondItemToBuy();
        if (item1a != null && item1b != null && item1a.getItem() == item1b.getItem() && item1a.getItemDamage() == item1b.getItemDamage() && item2a != null && item2b != null && item2a.getItem() == item2b.getItem() && item2a.getItemDamage() == item2b.getItemDamage()) {
            return item3a == null && item3b == null || item3a != null && item3b != null && item3a.getItem() == item3b.getItem() && item3a.getItemDamage() == item3b.getItemDamage();
        }
        return false;
    }

    public static boolean areTradesIdentical(MerchantRecipe a, MerchantRecipe b) {
        return ItemStack.areItemStacksEqual((ItemStack)a.getItemToBuy(), (ItemStack)b.getItemToBuy()) && ItemStack.areItemStacksEqual((ItemStack)a.getSecondItemToBuy(), (ItemStack)b.getSecondItemToBuy()) && ItemStack.areItemStacksEqual((ItemStack)a.getItemToSell(), (ItemStack)b.getItemToSell());
    }
}

