/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.entity.mobs.EntityBlackKnight;
import zeldaswordskills.entity.mobs.EntityGrandWizzrobe;
import zeldaswordskills.entity.mobs.EntityOctorok;
import zeldaswordskills.item.ItemHookShotUpgrade;
import zeldaswordskills.item.ItemPendant;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.world.crisis.BossBattle;
import zeldaswordskills.world.crisis.DesertBattle;
import zeldaswordskills.world.crisis.EarthBattle;
import zeldaswordskills.world.crisis.FireBattle;
import zeldaswordskills.world.crisis.ForestBattle;
import zeldaswordskills.world.crisis.OceanBattle;
import zeldaswordskills.world.crisis.SwampBattle;

public enum BossType {
    HELL("temple_fire", FireBattle.class, EntityBlaze.class, 7, ZeldaSongs.songWarpFire, "hell"),
    DESERT("temple_desert", DesertBattle.class, EntityBlaze.class, 1, ZeldaSongs.songWarpSpirit, "desert", "deserthills"),
    FOREST("temple_forest", ForestBattle.class, EntityCaveSpider.class, 4, ZeldaSongs.songWarpForest, "forest", "foresthills"),
    TAIGA("temple_ice", BossBattle.class, EntitySkeleton.class, 5, ZeldaSongs.songWarpLight, "coldtaiga", "coldtaigahills", "iceplains"),
    OCEAN("temple_water", OceanBattle.class, EntityOctorok.class, 1, ZeldaSongs.songWarpWater, "ocean", "frozenocean", "deepocean"),
    SWAMP("temple_wind", SwampBattle.class, EntityGrandWizzrobe.class, 4, ZeldaSongs.songWarpShadow, "swampland"),
    MOUNTAIN("temple_earth", EarthBattle.class, EntityBlackKnight.class, 3, ZeldaSongs.songWarpOrder, "extremehills", "extremehillsedge");

    private final String unlocalizedName;
    private final String[] defaultBiomes;
    private final Class<? extends BossBattle> bossBattle;
    private final Class<? extends IMob> bossMob;
    public final int metadata;
    public final AbstractZeldaSong warpSong;
    private static final Map<String, BossType> stringToTypeMap;
    private static final Map<String, BossType> bossBiomeList;
    private static final ItemStack[] desertItems;
    private static final ItemStack[] forestItems;
    private static final ItemStack[] mountainItems;
    private static final ItemStack[] netherItems;
    private static final ItemStack[] oceanItems;
    private static final ItemStack[] swampItems;
    private static final ItemStack[] taigaItems;

    private BossType(String name, Class<? extends BossBattle> bossBattle, Class<? extends IMob> bossMob, int meta, AbstractZeldaSong warpSong, String ... defaultBiomes) {
        this.unlocalizedName = name;
        this.defaultBiomes = defaultBiomes;
        this.bossBattle = bossBattle;
        this.bossMob = bossMob;
        this.metadata = meta;
        this.warpSong = warpSong;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getDisplayName() {
        return StatCollector.translateToLocal((String)("dungeon.zss." + this.unlocalizedName + ".name"));
    }

    public String toString() {
        return "Name: " + this.getUnlocalizedName() + " BossMob: " + (this.bossMob != null ? this.bossMob.toString() : "NULL") + " Block: " + this.metadata;
    }

    public static void postInit(Configuration config) {
        for (BossType type : BossType.values()) {
            BossType.addBiomes(type, config.get("Dungeon Generation", String.format("[Boss Dungeon] List of biomes in which %ss can generate", type.getDisplayName()), type.defaultBiomes).getStringList());
        }
    }

    public static void addBiomes(BossType type, String[] biomeNames) {
        for (String biome : biomeNames) {
            if (biome.length() < 1) continue;
            if (!BiomeType.isRealBiome(biome = biome.toLowerCase().replace(" ", ""))) {
                ZSSMain.logger.warn(String.format("%s is not a recognized biome! This entry will be ignored for BossType %s", biome, type.getDisplayName()));
                continue;
            }
            if (bossBiomeList.containsKey(biome)) {
                ZSSMain.logger.warn(String.format("Error while adding %s for %s: biome already mapped to %s", biome, type.getDisplayName(), bossBiomeList.get(biome).getDisplayName()));
                continue;
            }
            bossBiomeList.put(biome, type);
        }
    }

    public static BossType getBossType(String name) {
        if (stringToTypeMap.isEmpty()) {
            for (BossType type : BossType.values()) {
                stringToTypeMap.put(type.unlocalizedName, type);
            }
        }
        return stringToTypeMap.get(name.toLowerCase());
    }

    public static BossType getBossType(World world, int x, int z) {
        BiomeGenBase biome = world.getBiomeGenForCoords(x, z);
        if (biome == null) {
            ZSSMain.logger.warn(String.format("Null biome at %d/%d while getting Boss Type", x, z));
            return null;
        }
        if (Config.areBossDungeonsRandom()) {
            int i = world.rand.nextInt(BossType.values().length);
            return BossType.values()[i];
        }
        return bossBiomeList.get(biome.biomeName.toLowerCase().replace(" ", ""));
    }

    public ItemStack getSpecialItem() {
        switch (this) {
            case DESERT: {
                return new ItemStack(ZSSItems.pendant, 1, ItemPendant.PendantType.COURAGE.ordinal());
            }
            case MOUNTAIN: {
                return new ItemStack(ZSSItems.pendant, 1, ItemPendant.PendantType.POWER.ordinal());
            }
            case OCEAN: {
                return new ItemStack(ZSSItems.pendant, 1, ItemPendant.PendantType.WISDOM.ordinal());
            }
        }
        return null;
    }

    public ItemStack getRandomSpecialItem(Random rand) {
        ItemStack[] items = null;
        switch (this) {
            case DESERT: {
                items = desertItems;
                break;
            }
            case FOREST: {
                items = forestItems;
                break;
            }
            case HELL: {
                items = netherItems;
                break;
            }
            case MOUNTAIN: {
                items = mountainItems;
                break;
            }
            case OCEAN: {
                items = oceanItems;
                break;
            }
            case SWAMP: {
                items = swampItems;
                break;
            }
            case TAIGA: {
                items = taigaItems;
                break;
            }
        }
        if (items != null && items.length > 0) {
            return items[rand.nextInt(items.length)];
        }
        return null;
    }

    public final BossBattle getBossBattle(TileEntityDungeonCore core) {
        if (this.bossBattle == null) {
            ZSSMain.logger.error("Error retrieving boss battle event for " + this.toString());
            return null;
        }
        BossBattle battle = null;
        try {
            battle = this.bossBattle.getConstructor(TileEntityDungeonCore.class).newInstance(new Object[]{core});
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return battle;
    }

    public final Entity getNewMob(World world) {
        if (this.bossMob == null) {
            ZSSMain.logger.error("Error retrieving boss mob for " + this.toString());
            return null;
        }
        Entity entity = null;
        try {
            entity = (Entity)this.bossMob.getConstructor(World.class).newInstance(world);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return entity;
    }

    static {
        stringToTypeMap = new HashMap<String, BossType>();
        bossBiomeList = new HashMap<String, BossType>();
        desertItems = new ItemStack[]{new ItemStack(ZSSItems.boomerang), new ItemStack(ZSSItems.bootsHover), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.EXTENSION.ordinal()), new ItemStack(ZSSItems.maskGibdo), new ItemStack(ZSSItems.rodFire)};
        forestItems = new ItemStack[]{new ItemStack(ZSSItems.dekuLeaf), new ItemStack(ZSSItems.heroBow), new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.WOOD_SHOT.ordinal()), new ItemStack(ZSSItems.maskHawkeye), new ItemStack(ZSSItems.whip, 1, IWhipBlock.WhipType.WHIP_SHORT.ordinal())};
        mountainItems = new ItemStack[]{new ItemStack(ZSSItems.bootsPegasus), new ItemStack(ZSSItems.hammer), new ItemStack(ZSSItems.maskBlast), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.STONECLAW.ordinal()), new ItemStack(ZSSItems.swordBroken, 1, Item.getIdFromItem((Item)ZSSItems.swordGiant))};
        netherItems = new ItemStack[]{new ItemStack(ZSSItems.keySkeleton), new ItemStack(ZSSItems.heroBow), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.MULTI.ordinal()), new ItemStack(ZSSItems.maskMajora), new ItemStack(ZSSItems.tunicGoronChest)};
        oceanItems = new ItemStack[]{new ItemStack(ZSSItems.bootsHeavy), new ItemStack(ZSSItems.maskStone), new ItemStack(ZSSItems.slingshot), new ItemStack(ZSSItems.tunicZoraChest)};
        swampItems = new ItemStack[]{new ItemStack(ZSSItems.bootsRubber), new ItemStack(ZSSItems.hammer), new ItemStack(ZSSItems.heroBow), new ItemStack(ZSSItems.maskHawkeye), new ItemStack(ZSSItems.rodTornado)};
        taigaItems = new ItemStack[]{new ItemStack(ZSSItems.boomerang), new ItemStack(ZSSItems.bootsHover), new ItemStack(ZSSItems.gauntletsSilver), new ItemStack(ZSSItems.maskGiants), new ItemStack(ZSSItems.rodIce)};
    }
}

