/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.songs;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import zeldaswordskills.block.BlockWarpStone;
import zeldaswordskills.entity.ai.EntityAITeleport;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.PlaySoundPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.SongNote;
import zeldaswordskills.util.WarpPoint;
import zeldaswordskills.world.TeleporterNoPortal;

public class ZeldaSongWarp
extends AbstractZeldaSong {
    public ZeldaSongWarp(String unlocalizedName, int minDuration, SongNote ... notes) {
        super(unlocalizedName, minDuration, notes);
    }

    protected WarpPoint getWarpPoint(EntityPlayer player) {
        WarpPoint warp = ZSSPlayerSongs.get(player).getWarpPoint(this);
        return warp == null ? Config.getDefaultWarpPoint(this) : warp;
    }

    protected boolean canCrossDimensions() {
        return true;
    }

    protected boolean isBlockValid(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        return block instanceof BlockWarpStone && BlockWarpStone.warpBlockSongs.get(meta) == this;
    }

    @Override
    protected boolean hasEffect(EntityPlayer player, ItemStack instrument, int power) {
        return power > 4;
    }

    @Override
    protected void performEffect(EntityPlayer player, ItemStack instrument, int power) {
        WarpPoint warp = this.getWarpPoint(player);
        int dimension = player.worldObj.provider.dimensionId;
        if (warp == null) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.warp.null", new Object[0]);
        } else if (!this.canCrossDimensions() && dimension != warp.dimensionId) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.warp.dimension", new Object[0]);
        } else if (dimension == 1 && warp.dimensionId != 1) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.warp.end", new Object[0]);
        } else {
            if (player.ridingEntity != null) {
                player.mountEntity(null);
            }
            double dx = player.posX;
            double dy = player.posY;
            double dz = player.posZ;
            if (dimension != warp.dimensionId) {
                ((EntityPlayerMP)player).mcServer.getConfigurationManager().transferPlayerToDimension((EntityPlayerMP)player, warp.dimensionId, (Teleporter)new TeleporterNoPortal((WorldServer)player.worldObj));
            }
            boolean noBlock = true;
            boolean noAir = false;
            if (this.isBlockValid(player.worldObj, warp.x, warp.y, warp.z)) {
                noBlock = false;
                if (!EntityAITeleport.teleportTo(player.worldObj, (EntityLivingBase)player, (double)warp.x + 0.5, warp.y + 1, (double)warp.z + 0.5, null, true, false)) {
                    noAir = true;
                }
            }
            if (noBlock || noAir) {
                if (dimension != warp.dimensionId) {
                    ((EntityPlayerMP)player).mcServer.getConfigurationManager().transferPlayerToDimension((EntityPlayerMP)player, dimension, (Teleporter)new TeleporterNoPortal((WorldServer)player.worldObj));
                }
                player.setPositionAndUpdate(dx, dy, dz);
                PlayerUtils.sendTranslatedChat(player, noAir ? "chat.zss.song.warp.blocked" : "chat.zss.song.warp.missing", new Object[0]);
            } else {
                PacketDispatcher.sendTo(new PlaySoundPacket("zeldaswordskills:success", 1.0f, 1.0f), (EntityPlayerMP)player);
            }
        }
    }
}

