/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.songs;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.world.WorldServer;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.PlaySoundPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.SongNote;

public class ZeldaSongSun
extends AbstractZeldaSong {
    private static long nextChange;

    public ZeldaSongSun(String unlocalizedName, int minDuration, SongNote ... notes) {
        super(unlocalizedName, minDuration, notes);
    }

    @Override
    protected boolean hasEffect(EntityPlayer player, ItemStack instrument, int power) {
        return power > 4;
    }

    @Override
    protected void performEffect(EntityPlayer player, ItemStack instrument, int power) {
        if (!player.capabilities.isCreativeMode && player.worldObj.getTotalWorldTime() < nextChange) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.cooldown", new ChatComponentTranslation(this.getTranslationString(), new Object[0]), Config.getMinIntervalSun());
            return;
        }
        PacketDispatcher.sendTo(new PlaySoundPacket("zeldaswordskills:success", 1.0f, 1.0f), (EntityPlayerMP)player);
        long time = player.worldObj.getWorldTime() % 24000L;
        long addTime = time < 12000L ? 12000L - time : 24000L - time;
        for (int i = 0; i < MinecraftServer.getServer().worldServers.length; ++i) {
            WorldServer worldserver = MinecraftServer.getServer().worldServers[i];
            worldserver.setWorldTime(worldserver.getWorldTime() + addTime);
        }
        nextChange = player.worldObj.getTotalWorldTime() + (long)Config.getMinIntervalSun();
    }
}

