/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.songs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.PlaySoundPacket;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.SongNote;

public class ZeldaSongSoaring
extends AbstractZeldaSong {
    public ZeldaSongSoaring(String unlocalizedName, int minDuration, SongNote ... notes) {
        super(unlocalizedName, minDuration, notes);
    }

    @Override
    protected boolean hasEffect(EntityPlayer player, ItemStack instrument, int power) {
        return power > 4 && Math.abs(player.dimension) != 1;
    }

    @Override
    protected void performEffect(EntityPlayer player, ItemStack instrument, int power) {
        ChunkCoordinates cc = player.getBedLocation(player.dimension);
        if (cc != null) {
            cc = EntityPlayer.verifyRespawnCoordinates((World)player.worldObj, (ChunkCoordinates)cc, (boolean)player.isSpawnForced(player.dimension));
        }
        if (cc == null) {
            cc = player.worldObj.getSpawnPoint();
        }
        if (cc != null) {
            if (player.ridingEntity != null) {
                player.mountEntity(null);
            }
            player.setPosition((double)cc.posX + 0.5, (double)cc.posY + 0.1, (double)cc.posZ + 0.5);
            while (!player.worldObj.getCollidingBoundingBoxes((Entity)player, player.boundingBox).isEmpty()) {
                player.setPosition(player.posX, player.posY + 1.0, player.posZ);
            }
            player.setPositionAndUpdate(player.posX, player.posY, player.posZ);
            PacketDispatcher.sendTo(new PlaySoundPacket("zeldaswordskills:success", 1.0f, 1.0f), (EntityPlayerMP)player);
        }
    }
}

