/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.songs;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S18PacketEntityTeleport;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.SongNote;

public class ZeldaSongEpona
extends AbstractZeldaSong {
    public ZeldaSongEpona(String unlocalizedName, int minDuration, SongNote ... notes) {
        super(unlocalizedName, minDuration, notes);
    }

    @Override
    protected void performEffect(EntityPlayer player, ItemStack instrument, int power) {
        List horses = player.worldObj.getEntitiesWithinAABB(EntityHorse.class, player.boundingBox.expand(8.0, 4.0, 8.0));
        for (EntityHorse horse : horses) {
            if (horse.isTame()) continue;
            horse.setTamedBy(player);
            player.worldObj.setEntityState((Entity)horse, (byte)18);
        }
        ZSSPlayerSongs songs = ZSSPlayerSongs.get(player);
        List cows = player.worldObj.getEntitiesWithinAABB(EntityCow.class, player.boundingBox.expand(8.0, 4.0, 8.0));
        for (EntityCow cow : cows) {
            songs.addLonLonCow(cow);
        }
        if (power < 5) {
            return;
        }
        int x = MathHelper.floor_double((double)player.posX);
        int y = MathHelper.floor_double((double)player.boundingBox.maxY);
        int z = MathHelper.floor_double((double)player.posZ);
        if (!player.worldObj.provider.isSurfaceWorld()) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.epona.dimension", new Object[0]);
        } else if (!player.worldObj.canBlockSeeTheSky(x, y, z)) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.epona.sky", new Object[0]);
        } else {
            EntityHorse epona = songs.getLastHorseRidden();
            if (epona == null) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.song.epona.missing", new Object[0]);
            } else {
                if (epona.riddenByEntity != null) {
                    epona.riddenByEntity.mountEntity(null);
                }
                if (epona.getLeashed()) {
                    epona.clearLeashed(true, true);
                }
                Vec3 vec3 = player.getLookVec();
                epona.setPosition(player.posX + vec3.xCoord * 2.0, player.posY + 1.0, player.posZ + vec3.zCoord * 2.0);
                S18PacketEntityTeleport packet = new S18PacketEntityTeleport((Entity)epona);
                PacketDispatcher.sendTo((Packet)packet, player);
                PacketDispatcher.sendToPlayersExcept((Packet)packet, player, ((WorldServer)player.worldObj).getEntityTracker().getTrackingPlayers((Entity)epona));
                epona.makeHorseRearWithSound();
                songs.setHorseRidden(epona);
            }
        }
    }
}

