/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.songs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.api.block.ISongBlock;
import zeldaswordskills.api.entity.ISongEntity;
import zeldaswordskills.item.ItemInstrument;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.SongNote;

public abstract class AbstractZeldaSong {
    public static final int MAX_SONG_RADIUS = 16;
    private final String unlocalizedName;
    private final int minDuration;
    private final List<SongNote> notes;
    protected boolean isEnabled;

    public AbstractZeldaSong(String unlocalizedName, int minDuration, SongNote ... notes) {
        if (!("scarecrow".equals(unlocalizedName) || notes != null && notes.length >= 3)) {
            throw new IllegalArgumentException("Songs must be composed of at least 3 notes!");
        }
        this.unlocalizedName = unlocalizedName;
        this.minDuration = minDuration;
        this.notes = Collections.unmodifiableList(Arrays.asList(notes));
        this.isEnabled = true;
        ZeldaSongs.register(this);
    }

    public String getDisplayName() {
        return StatCollector.translateToLocal((String)this.getTranslationString());
    }

    public String getTranslationString() {
        return "song.zss." + this.unlocalizedName + ".name";
    }

    public String getSoundString() {
        return "zeldaswordskills:song." + this.unlocalizedName;
    }

    public boolean playSuccessSound() {
        return true;
    }

    public boolean canLearn(EntityPlayer player) {
        return true;
    }

    public boolean canLearnFromCommand() {
        return true;
    }

    public boolean canLearnFromInscription(World world, int x, int y, int z, Block block, int meta) {
        return true;
    }

    protected abstract void performEffect(EntityPlayer var1, ItemStack var2, int var3);

    protected boolean hasEffect(EntityPlayer player, ItemStack instrument, int power) {
        return true;
    }

    protected int getNotifyBlockRadius(EntityPlayer player, ItemStack stack, int power) {
        return 8;
    }

    protected int getNotifyEntityRadius(EntityPlayer player, ItemStack stack, int power) {
        return 8;
    }

    public final boolean equals(Object o) {
        return this.unlocalizedName.equals(o);
    }

    public final int hashCode() {
        return this.unlocalizedName.hashCode();
    }

    public final String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public final int getMinDuration() {
        return this.minDuration;
    }

    public final List<SongNote> getNotes() {
        return this.notes;
    }

    public final boolean areCorrectNotes(List<SongNote> notesPlayed) {
        if (this.notes == null || this.notes.size() < 1 || notesPlayed == null || notesPlayed.size() != this.notes.size()) {
            return false;
        }
        for (int i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get(i) == notesPlayed.get(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean isSongPartOfNotes(List<SongNote> notesPlayed) {
        if (this.notes == null || this.notes.size() < 1 || notesPlayed == null || notesPlayed.size() < this.notes.size()) {
            return false;
        }
        for (int i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get(i) == notesPlayed.get(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public final void performSongEffects(EntityPlayer player) {
        if (!player.worldObj.isRemote) {
            ItemStack instrument = player.getHeldItem();
            if (instrument == null || !(instrument.getItem() instanceof ItemInstrument)) {
                return;
            }
            int power = ((ItemInstrument)instrument.getItem()).getSongStrength(instrument);
            int r = this.getNotifyBlockRadius(player, instrument, power);
            if (r > 0) {
                this.notifySongBlocks(player.worldObj, player, power, Math.min(r, 16));
            }
            if ((r = this.getNotifyEntityRadius(player, instrument, power)) > 0) {
                this.notifySongEntities(player.worldObj, player, power, Math.min(r, 16));
            }
            if (!this.isEnabled()) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.song.disabled", new ChatComponentTranslation(this.getTranslationString(), new Object[0]));
            } else if (this.hasEffect(player, instrument, power)) {
                this.performEffect(player, instrument, power);
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.song.failed", new ChatComponentTranslation(this.getTranslationString(), new Object[0]));
            }
        }
    }

    private void notifySongBlocks(World world, EntityPlayer player, int power, int radius) {
        int x = MathHelper.floor_double((double)player.posX);
        int y = MathHelper.floor_double((double)player.boundingBox.minY);
        int z = MathHelper.floor_double((double)player.posZ);
        int affected = 0;
        for (int i = x - radius; i <= x + radius; ++i) {
            for (int j = y - radius / 2; j <= y + radius / 2; ++j) {
                for (int k = z - radius; k <= z + radius; ++k) {
                    Block block = world.getBlock(i, j, k);
                    if (!(block instanceof ISongBlock) || !((ISongBlock)block).onSongPlayed(world, i, j, k, player, this, power, affected)) continue;
                    ++affected;
                }
            }
        }
    }

    private void notifySongEntities(World world, EntityPlayer player, int power, int radius) {
        int affected = 0;
        List entities = world.getEntitiesWithinAABB(ISongEntity.class, player.boundingBox.expand((double)radius, (double)radius / 2.0, (double)radius));
        for (ISongEntity entity : entities) {
            if (!entity.onSongPlayed(player, this, power, affected)) continue;
            ++affected;
        }
    }
}

