/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class SwordBreak
extends SkillActive {
    private int breakTimer;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private boolean playMissSound;

    public SwordBreak(String name) {
        super(name);
    }

    private SwordBreak(SwordBreak skill) {
        super(skill);
    }

    @Override
    public SwordBreak newInstance() {
        return new SwordBreak(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 1), (Object[])new Object[]{this.getMaxDamage()}));
        desc.add(this.getTimeLimitDisplay(this.getActiveTime() - this.getUseDelay()));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.breakTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    private int getActiveTime() {
        return 6 + this.level;
    }

    private int getUseDelay() {
        return 5 - this.level / 2;
    }

    private int getMaxDamage() {
        return (this.level + 1) * 15;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.getHeldItem());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.canUse(player) && PlayerUtils.isBlocking(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == ZSSKeyHandler.keys[5] || Config.allowVanillaControls && key == mc.gameSettings.keyBindBack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            if (Config.requireDoubleTap) {
                if (this.ticksTilFail > 0) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                    this.ticksTilFail = 0;
                    return true;
                }
                this.ticksTilFail = 6;
            } else if (key != mc.gameSettings.keyBindBack) {
                PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.breakTimer = this.getActiveTime();
        this.playMissSound = true;
        if (world.isRemote) {
            KeyBinding.setKeyBindState((int)Minecraft.getMinecraft().gameSettings.keyBindUseItem.getKeyCode(), (boolean)false);
            KeyBinding.setKeyBindState((int)ZSSKeyHandler.keys[6].getKeyCode(), (boolean)false);
            player.swingItem();
        }
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.breakTimer = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            if (--this.breakTimer <= this.getUseDelay() && this.playMissSound) {
                this.playMissSound = false;
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
            }
        } else if (player.worldObj.isRemote && this.ticksTilFail > 0) {
            --this.ticksTilFail;
        }
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (source.getSourceOfDamage() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.getSourceOfDamage();
            ItemStack stackToDamage = attacker.getHeldItem();
            if (this.breakTimer > this.getUseDelay() && stackToDamage != null && PlayerUtils.isWeapon(player.getHeldItem())) {
                this.breakTimer = this.getUseDelay();
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
                this.playMissSound = false;
                if (!player.worldObj.isRemote) {
                    int dmg = Math.max(this.getMaxDamage() / 3, player.worldObj.rand.nextInt(this.getMaxDamage()));
                    stackToDamage.damageItem(dmg, attacker);
                    if (stackToDamage.stackSize <= 0) {
                        player.worldObj.playSoundAtEntity((Entity)attacker, "random.break", 0.8f, 0.8f + player.worldObj.rand.nextFloat() * 0.4f);
                        attacker.setCurrentItemOrArmor(0, null);
                    }
                }
                TargetUtils.knockTargetBack(attacker, (EntityLivingBase)player);
                return true;
            }
        }
        return false;
    }
}

