/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.block.BlockAncientTablet;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntityBombosFireball;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.network.server.RefreshSpinPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class SpinAttack
extends SkillActive {
    private int charge;
    private float currentSpin;
    private float arc;
    private int refreshed;
    @SideOnly(value=Side.CLIENT)
    private boolean clockwise;
    @SideOnly(value=Side.CLIENT)
    private boolean wasKeyPressed;
    @SideOnly(value=Side.CLIENT)
    private List<EntityLivingBase> targets;
    private boolean isFlaming;
    private boolean isBombos;
    private int superLevel;

    public SpinAttack(String name) {
        super(name);
    }

    private SpinAttack(SpinAttack skill) {
        super(skill);
    }

    @Override
    public SpinAttack newInstance() {
        return new SpinAttack(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        byte temp = this.level;
        if (!this.isActive()) {
            this.superLevel = this.checkHealth(player) ? (int)ZSSPlayerSkills.get(player).getSkillLevel(superSpinAttack) : 0;
            this.level = ZSSPlayerSkills.get(player).getSkillLevel(spinAttack);
        }
        desc.add(this.getChargeDisplay(this.getChargeTime()));
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 1).replace("super", ""), (Object[])new Object[]{this.superLevel + 1}));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
        if (this.getId() == superSpinAttack.getId()) {
            desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 2), (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getMagicCost()))}));
        }
        this.level = temp;
    }

    @Override
    public boolean canDrop() {
        return this == spinAttack;
    }

    @Override
    public boolean isLoot() {
        return this == spinAttack;
    }

    @Override
    public boolean isActive() {
        return this.arc > 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.isActive() && !this.isCharging();
    }

    @Override
    protected float getExhaustion() {
        return this.refreshed > 0 ? 0.0f : 3.0f - 0.2f * (float)this.level;
    }

    private float getMagicCost() {
        return 5.75f - 0.75f * (float)this.superLevel;
    }

    private int getChargeTime() {
        return 20 - this.level * 2;
    }

    private boolean isCharging() {
        return this.charge > 0;
    }

    private boolean canRefresh(EntityPlayer player) {
        float cost = this.getMagicCost();
        if (this.isBombos && ZSSPlayerInfo.get(player).getCurrentMagic() < 10.0f + cost) {
            this.isBombos = false;
        }
        if (ZSSPlayerInfo.get(player).getCurrentMagic() < cost) {
            return false;
        }
        return this.refreshed < this.superLevel + 1 && this.arc == 360.0f * (float)this.refreshed;
    }

    private float getRange() {
        return 3.0f + (float)(this.superLevel + this.level) * 0.5f;
    }

    private float getSpinSpeed() {
        return 70 + 3 * (this.superLevel + this.level);
    }

    private boolean checkHealth(EntityPlayer player) {
        return player.capabilities.isCreativeMode || PlayerUtils.getHealthMissing(player) <= Config.getHealthAllowance(this.level);
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return super.canUse(player) && PlayerUtils.isWeapon(player.getHeldItem());
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isKeyPressed() {
        return ZSSKeyHandler.keys[3].getIsKeyPressed() || ZSSKeyHandler.keys[4].getIsKeyPressed() || Config.allowVanillaControls && Minecraft.getMinecraft().gameSettings.keyBindLeft.getIsKeyPressed() && Minecraft.getMinecraft().gameSettings.keyBindRight.getIsKeyPressed();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return Config.allowVanillaControls && (key == mc.gameSettings.keyBindLeft || key == mc.gameSettings.keyBindRight) || key == ZSSKeyHandler.keys[3] || key == ZSSKeyHandler.keys[4];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == mc.gameSettings.keyBindAttack || key == ZSSKeyHandler.keys[2]) {
            if (this.isActive() && this.canRefresh(player) && this.canExecute(player)) {
                PacketDispatcher.sendToServer(new RefreshSpinPacket());
                this.refreshSpin(player);
                return true;
            }
        } else if (!this.isCharging()) {
            if (this.wasKeyPressed) {
                this.wasKeyPressed = false;
            } else {
                this.clockwise = key == ZSSKeyHandler.keys[4] || key == mc.gameSettings.keyBindRight;
                this.wasKeyPressed = true;
            }
            if (this.isKeyPressed()) {
                this.wasKeyPressed = false;
                this.charge = this.getChargeTime();
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.currentSpin = 0.0f;
        this.arc = 360.0f;
        this.refreshed = 0;
        int n = this.superLevel = this.checkHealth(player) ? (int)ZSSPlayerSkills.get(player).getSkillLevel(superSpinAttack) : 0;
        if (PlayerUtils.isHoldingMasterSword((EntityLivingBase)player) && PlayerUtils.hasItem(player, ZSSItems.medallion, BlockAncientTablet.EnumType.BOMBOS.ordinal())) {
            this.isBombos = ZSSPlayerInfo.get(player).useMagic(10.0f);
        }
        this.isFlaming = this.isBombos || EnchantmentHelper.getFireAspectModifier((EntityLivingBase)player) > 0;
        this.startSpin(world, player);
        return true;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.charge = 0;
        this.currentSpin = 0.0f;
        this.arc = 0.0f;
        this.isBombos = false;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isCharging()) {
            if (PlayerUtils.isWeapon(player.getHeldItem()) && player.worldObj.isRemote && this.isKeyPressed()) {
                if (this.charge < this.getChargeTime() - 1) {
                    Minecraft.getMinecraft().playerController.sendUseItem(player, player.worldObj, player.getHeldItem());
                }
                --this.charge;
                if (this.charge == 0 && this.canExecute(player)) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                }
            } else {
                this.charge = 0;
            }
        } else if (this.isActive()) {
            this.incrementSpin(player);
            if (this.isBombos && !player.worldObj.isRemote) {
                this.spawnFireballs(player);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        if (PlayerUtils.isWeapon(player.getHeldItem())) {
            List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, (int)(this.getRange() + 0.5f), 1.0);
            for (EntityLivingBase target : list) {
                if (this.targets == null || !this.targets.contains(target)) continue;
                Minecraft.getMinecraft().playerController.attackEntity(player, (Entity)target);
                this.targets.remove(target);
            }
            this.spawnParticles(player);
            player.swingProgress = 0.5f;
            player.setAngles(this.clockwise ? this.getSpinSpeed() : -this.getSpinSpeed(), 0.0f);
        }
        return true;
    }

    private void startSpin(World world, EntityPlayer player) {
        ++this.refreshed;
        if (world.isRemote) {
            this.targets = world.getEntitiesWithinAABB(EntityLivingBase.class, player.boundingBox.expand((double)this.getRange(), 0.0, (double)this.getRange()));
            if (this.targets.contains(player)) {
                this.targets.remove(player);
            }
        } else {
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:spinattack", 0.4f, 0.5f);
        }
    }

    private void incrementSpin(EntityPlayer player) {
        this.currentSpin = (float)((double)this.currentSpin + (double)this.getSpinSpeed() * 0.24);
        if (this.currentSpin >= this.arc) {
            this.deactivate(player);
        } else if (this.currentSpin > 360.0f * (float)this.refreshed) {
            this.startSpin(player.worldObj, player);
        }
    }

    private void spawnFireballs(EntityPlayer player) {
        player.worldObj.spawnEntityInWorld((Entity)new EntityBombosFireball(player.worldObj, (EntityLivingBase)player).setDamage(10.0f));
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EntityPlayer player) {
        String particle = this.isFlaming ? "flame" : (this.superLevel > 0 ? "magicCrit" : "crit");
        Vec3 vec3 = player.getLookVec();
        double posX = player.posX + vec3.xCoord * (double)this.getRange();
        double posY = player.posY + (double)player.getEyeHeight() - 0.1;
        double posZ = player.posZ + vec3.zCoord * (double)this.getRange();
        for (int i = 0; i < 2; ++i) {
            player.worldObj.spawnParticle(particle, posX, posY, posZ, vec3.xCoord * 0.15, 0.01, vec3.zCoord * 0.15);
        }
    }

    public void refreshServerSpin(EntityPlayer player) {
        if (this.canRefresh(player) && super.canUse(player) && PlayerUtils.isWeapon(player.getHeldItem())) {
            this.refreshSpin(player);
        }
    }

    private void refreshSpin(EntityPlayer player) {
        if (ZSSPlayerInfo.get(player).useMagic(this.getMagicCost())) {
            this.arc += 360.0f;
        }
        if (this.isBombos && !ZSSPlayerInfo.get(player).useMagic(10.0f)) {
            this.isBombos = false;
        }
    }
}

