/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import zeldaswordskills.client.ZSSClientEvents;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntityLeapingBlow;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.skills.sword.SwordBasic;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class LeapingBlow
extends SkillActive {
    private boolean isActive;
    private boolean isMaster;

    public LeapingBlow(String name) {
        super(name);
    }

    private LeapingBlow(LeapingBlow skill) {
        super(skill);
    }

    @Override
    public LeapingBlow newInstance() {
        return new LeapingBlow(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(PlayerUtils.isHoldingMasterSword((EntityLivingBase)player) ? this.level * 2 : this.level, true));
        desc.add(this.getRangeDisplay(3.0f + 0.5f * (float)this.level));
        desc.add(this.getAreaDisplay(0.5f + 0.25f * (float)this.level));
        desc.add(this.getDurationDisplay(this.getPotionDuration(player), false));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    @Override
    protected boolean autoAddExhaustion() {
        return false;
    }

    private float getDamage(EntityPlayer player) {
        return (float)((double)(PlayerUtils.isHoldingMasterSword((EntityLivingBase)player) ? this.level * 2 : this.level) + player.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue());
    }

    private int getPotionDuration(EntityPlayer player) {
        return (PlayerUtils.isHoldingMasterSword((EntityLivingBase)player) ? 110 : 50) + this.level * 10;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isSword(player.getHeldItem()) && !TargetUtils.isInLiquid((Entity)player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return !this.isActive() && player.onGround && PlayerUtils.isBlocking(player) && !TargetUtils.isInLiquid((Entity)player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == mc.gameSettings.keyBindJump;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            KeyBinding.setKeyBindState((int)mc.gameSettings.keyBindUseItem.getKeyCode(), (boolean)false);
            KeyBinding.setKeyBindState((int)ZSSKeyHandler.keys[6].getKeyCode(), (boolean)false);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.isActive = true;
        this.isMaster = PlayerUtils.isHoldingMasterSword((EntityLivingBase)player) && PlayerUtils.getHealthMissing(player) == 0.0f;
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.isActive = false;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (player.worldObj.isRemote && this.isActive() && (player.onGround || TargetUtils.isInLiquid((Entity)player))) {
            this.deactivate(player);
        }
    }

    public void onImpact(EntityPlayer player, float distance) {
        SwordBasic swordSkill = (SwordBasic)ZSSPlayerSkills.get(player).getPlayerSkill(swordBasic);
        if (this.isActive() && swordSkill != null && swordSkill.isActive() && PlayerUtils.isSword(player.getHeldItem())) {
            if (player.worldObj.isRemote) {
                if (distance < 1.0f) {
                    ZSSClientEvents.performComboAttack(Minecraft.getMinecraft(), swordSkill);
                } else {
                    player.swingItem();
                }
            } else if (distance >= 1.0f) {
                player.addExhaustion(this.getExhaustion());
                EntityLeapingBlow entity = new EntityLeapingBlow(player.worldObj, (EntityLivingBase)player).setDamage(this.getDamage(player)).setLevel(this.level, this.isMaster);
                player.worldObj.spawnEntityInWorld((Entity)entity);
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:leapingblow", 0.4f, 0.5f);
            }
        }
        this.onDeactivated(player.worldObj, player);
    }
}

