/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.server;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import zeldaswordskills.network.AbstractMessage;

public class FallDistancePacket
extends AbstractMessage.AbstractServerMessage<FallDistancePacket> {
    private int entityId;
    private float fallMod;

    public FallDistancePacket() {
    }

    public FallDistancePacket(Entity entity, float fallMod) {
        this.entityId = entity.getEntityId();
        this.fallMod = fallMod;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.entityId = buffer.readInt();
        this.fallMod = buffer.readFloat();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.entityId);
        buffer.writeFloat(this.fallMod);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        EntityPlayer entity;
        Object object = entity = this.entityId == player.getEntityId() ? player : player.worldObj.getEntityByID(this.entityId);
        if (entity != null) {
            entity.fallDistance = this.fallMod == 0.0f ? 0.0f : (entity.fallDistance += this.fallMod);
        }
    }
}

