/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.server;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.item.ICyclableItem;
import zeldaswordskills.network.AbstractMessage;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.SetItemModePacket;

public class CycleItemModePacket
extends AbstractMessage.AbstractServerMessage<CycleItemModePacket> {
    private boolean next;

    public CycleItemModePacket() {
    }

    public CycleItemModePacket(boolean next) {
        this.next = next;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.next = buffer.readBoolean();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeBoolean(this.next);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        ItemStack stack = player.getHeldItem();
        if (stack == null || !(stack.getItem() instanceof ICyclableItem)) {
            ZSSMain.logger.warn("Received CycleItemModePacket with invalid held item " + stack);
            return;
        }
        if (this.next) {
            ((ICyclableItem)stack.getItem()).nextItemMode(stack, player);
        } else {
            ((ICyclableItem)stack.getItem()).prevItemMode(stack, player);
        }
        if (player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SetItemModePacket(((ICyclableItem)stack.getItem()).getCurrentMode(stack, player)), (EntityPlayerMP)player);
        }
    }
}

