/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.network.AbstractMessage;

public class UnpressKeyPacket
extends AbstractMessage.AbstractClientMessage<UnpressKeyPacket> {
    @SideOnly(value=Side.CLIENT)
    private static Map<Integer, KeyBinding> keyMap;
    public static final int LMB = -100;
    public static final int RMB = -99;
    public static final int MMB = -98;
    private int keyCode;

    @SideOnly(value=Side.CLIENT)
    public static void init() {
        Minecraft mc = Minecraft.getMinecraft();
        keyMap = new HashMap<Integer, KeyBinding>();
        UnpressKeyPacket.addKeyMapping(-100, mc.gameSettings.keyBindAttack);
        UnpressKeyPacket.addKeyMapping(-99, mc.gameSettings.keyBindUseItem);
        UnpressKeyPacket.addKeyMapping(-98, mc.gameSettings.keyBindPickBlock);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addKeyMapping(int keyCode, KeyBinding kb) {
        if (keyMap.containsKey(keyCode)) {
            ZSSMain.logger.warn("UnpressKeyPacket already contains a mapping for key code " + keyCode + "! Key binding " + kb + " will not have a mapping.");
        } else {
            keyMap.put(keyCode, kb);
        }
    }

    public UnpressKeyPacket() {
    }

    public UnpressKeyPacket(int keyCode) {
        this.keyCode = keyCode;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.keyCode = buffer.readInt();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.keyCode);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (this.keyCode == 0) {
            KeyBinding.unPressAllKeys();
        } else if (keyMap.containsKey(this.keyCode)) {
            KeyBinding.setKeyBindState((int)keyMap.get(this.keyCode).getKeyCode(), (boolean)false);
        }
    }
}

