/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import zeldaswordskills.network.AbstractMessage;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.network.bidirectional.AttackTimePacket;
import zeldaswordskills.network.bidirectional.DeactivateSkillPacket;
import zeldaswordskills.network.bidirectional.LearnSongPacket;
import zeldaswordskills.network.bidirectional.PlayRecordPacket;
import zeldaswordskills.network.bidirectional.PlaySoundPacket;
import zeldaswordskills.network.client.AttackBlockedPacket;
import zeldaswordskills.network.client.InLiquidPacket;
import zeldaswordskills.network.client.MortalDrawPacket;
import zeldaswordskills.network.client.OpenGossipStoneEditorPacket;
import zeldaswordskills.network.client.OpenSongGuiPacket;
import zeldaswordskills.network.client.PacketISpawnParticles;
import zeldaswordskills.network.client.SetItemModePacket;
import zeldaswordskills.network.client.SetNockedArrowPacket;
import zeldaswordskills.network.client.SpawnNayruParticlesPacket;
import zeldaswordskills.network.client.SyncConfigPacket;
import zeldaswordskills.network.client.SyncCurrentMagicPacket;
import zeldaswordskills.network.client.SyncEntityInfoPacket;
import zeldaswordskills.network.client.SyncPlayerInfoPacket;
import zeldaswordskills.network.client.SyncQuestPacket;
import zeldaswordskills.network.client.SyncQuestsPacket;
import zeldaswordskills.network.client.SyncSkillPacket;
import zeldaswordskills.network.client.UnpressKeyPacket;
import zeldaswordskills.network.client.UpdateBuffPacket;
import zeldaswordskills.network.client.UpdateComboPacket;
import zeldaswordskills.network.server.AddExhaustionPacket;
import zeldaswordskills.network.server.BombTickPacket;
import zeldaswordskills.network.server.BorrowMaskPacket;
import zeldaswordskills.network.server.CycleItemModePacket;
import zeldaswordskills.network.server.DashImpactPacket;
import zeldaswordskills.network.server.EndComboPacket;
import zeldaswordskills.network.server.FallDistancePacket;
import zeldaswordskills.network.server.GetBombPacket;
import zeldaswordskills.network.server.OpenGuiPacket;
import zeldaswordskills.network.server.RefreshSpinPacket;
import zeldaswordskills.network.server.RequestCurrentMagicPacket;
import zeldaswordskills.network.server.SetGossipStoneMessagePacket;
import zeldaswordskills.network.server.TargetIdPacket;
import zeldaswordskills.network.server.ZeldaSongPacket;

public class PacketDispatcher {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("zss_channel");

    public static final void preInit() {
        PacketDispatcher.registerMessage(ActivateSkillPacket.class);
        PacketDispatcher.registerMessage(AttackTimePacket.class);
        PacketDispatcher.registerMessage(DeactivateSkillPacket.class);
        PacketDispatcher.registerMessage(LearnSongPacket.class);
        PacketDispatcher.registerMessage(PlayRecordPacket.class);
        PacketDispatcher.registerMessage(PlaySoundPacket.class);
        PacketDispatcher.registerMessage(AttackBlockedPacket.class);
        PacketDispatcher.registerMessage(InLiquidPacket.class);
        PacketDispatcher.registerMessage(MortalDrawPacket.class);
        PacketDispatcher.registerMessage(OpenGossipStoneEditorPacket.class);
        PacketDispatcher.registerMessage(OpenSongGuiPacket.class);
        PacketDispatcher.registerMessage(PacketISpawnParticles.class);
        PacketDispatcher.registerMessage(SetItemModePacket.class);
        PacketDispatcher.registerMessage(SetNockedArrowPacket.class);
        PacketDispatcher.registerMessage(SpawnNayruParticlesPacket.class);
        PacketDispatcher.registerMessage(SyncConfigPacket.class);
        PacketDispatcher.registerMessage(SyncCurrentMagicPacket.class);
        PacketDispatcher.registerMessage(SyncEntityInfoPacket.class);
        PacketDispatcher.registerMessage(SyncPlayerInfoPacket.class);
        PacketDispatcher.registerMessage(SyncQuestPacket.class);
        PacketDispatcher.registerMessage(SyncQuestsPacket.class);
        PacketDispatcher.registerMessage(SyncSkillPacket.class);
        PacketDispatcher.registerMessage(UnpressKeyPacket.class);
        PacketDispatcher.registerMessage(UpdateBuffPacket.class);
        PacketDispatcher.registerMessage(UpdateComboPacket.class);
        PacketDispatcher.registerMessage(AddExhaustionPacket.class);
        PacketDispatcher.registerMessage(BombTickPacket.class);
        PacketDispatcher.registerMessage(BorrowMaskPacket.class);
        PacketDispatcher.registerMessage(CycleItemModePacket.class);
        PacketDispatcher.registerMessage(DashImpactPacket.class);
        PacketDispatcher.registerMessage(EndComboPacket.class);
        PacketDispatcher.registerMessage(FallDistancePacket.class);
        PacketDispatcher.registerMessage(GetBombPacket.class);
        PacketDispatcher.registerMessage(OpenGuiPacket.class);
        PacketDispatcher.registerMessage(RefreshSpinPacket.class);
        PacketDispatcher.registerMessage(RequestCurrentMagicPacket.class);
        PacketDispatcher.registerMessage(SetGossipStoneMessagePacket.class);
        PacketDispatcher.registerMessage(TargetIdPacket.class);
        PacketDispatcher.registerMessage(ZeldaSongPacket.class);
    }

    private static final <T extends AbstractMessage<T>> void registerMessage(Class<T> clazz) {
        if (AbstractMessage.AbstractClientMessage.class.isAssignableFrom(clazz)) {
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.CLIENT);
        } else if (AbstractMessage.AbstractServerMessage.class.isAssignableFrom(clazz)) {
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        } else {
            dispatcher.registerMessage(clazz, clazz, (int)packetId, Side.CLIENT);
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        }
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    public static void sendToPlayers(IMessage message, Collection<EntityPlayer> players) {
        for (EntityPlayer player : players) {
            if (!(player instanceof EntityPlayerMP)) continue;
            dispatcher.sendTo(message, (EntityPlayerMP)player);
        }
    }

    public static void sendToAll(IMessage message) {
        dispatcher.sendToAll(message);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, Entity entity, double range) {
        PacketDispatcher.sendToAllAround(message, entity.worldObj.provider.dimensionId, entity.posX, entity.posY, entity.posZ, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }

    public static void sendTo(Packet packet, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).playerNetServerHandler.sendPacket(packet);
        }
    }

    public static void sendToPlayers(Packet packet, Collection<EntityPlayer> players) {
        for (EntityPlayer player : players) {
            if (!(player instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)player).playerNetServerHandler.sendPacket(packet);
        }
    }

    public static void sendToPlayersExcept(Packet packet, EntityPlayer player, Collection<EntityPlayer> players) {
        for (EntityPlayer p : players) {
            if (p == player || !(p instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)p).playerNetServerHandler.sendPacket(packet);
        }
    }

    public static void sendToAll(Packet packet, World world) {
        if (world instanceof WorldServer) {
            for (Object o : ((WorldServer)world).playerEntities) {
                if (!(o instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)o).playerNetServerHandler.sendPacket(packet);
            }
        }
    }

    public static void sendToAllAround(Packet packet, Entity entity, int range) {
        int rangeSq = range * range;
        if (entity.worldObj instanceof WorldServer) {
            for (Object o : ((WorldServer)entity.worldObj).playerEntities) {
                EntityPlayerMP player;
                if (!(o instanceof EntityPlayerMP) || !((player = (EntityPlayerMP)o).getDistanceSqToEntity(entity) <= (double)rangeSq)) continue;
                ((EntityPlayerMP)o).playerNetServerHandler.sendPacket(packet);
            }
        }
    }
}

