/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.api.ISheathed;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.shield.IArrowCatcher;
import mods.battlegear2.api.shield.IArrowDisplay;
import mods.battlegear2.api.shield.IShield;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.damage.IDamageAoE;
import zeldaswordskills.api.entity.IReflectable;
import zeldaswordskills.api.item.IDashItem;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.ISwingSpeed;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="mods.battlegear2.api.ISheathed", modid="battlegear2", striprefs=true), @Optional.Interface(iface="mods.battlegear2.api.shield.IArrowCatcher", modid="battlegear2", striprefs=true), @Optional.Interface(iface="mods.battlegear2.api.shield.IArrowDisplay", modid="battlegear2", striprefs=true), @Optional.Interface(iface="mods.battlegear2.api.shield.IShield", modid="battlegear2", striprefs=true)})
public class ItemZeldaShield
extends Item
implements IDashItem,
IFairyUpgrade,
ISwingSpeed,
IUnenchantable,
IShield,
ISheathed,
IArrowCatcher,
IArrowDisplay {
    protected final Item.ToolMaterial toolMaterial;
    private final float magicReduction;
    private final int recoveryTime;
    private final float bg2DecayRate;
    private final float bg2RecoveryRate;
    @SideOnly(value=Side.CLIENT)
    private IIcon backIcon;

    public ItemZeldaShield(Item.ToolMaterial material, float magicReduction, int recoveryTime, float decayRate, float recoveryRate) {
        this.toolMaterial = material;
        this.magicReduction = magicReduction;
        this.recoveryTime = recoveryTime;
        this.bg2DecayRate = 1.0f / decayRate / 20.0f;
        this.bg2RecoveryRate = 1.0f / recoveryRate / 20.0f;
        this.setFull3D();
        this.setMaxDamage(64);
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabCombat);
    }

    public int getRecoveryTime() {
        return this.recoveryTime;
    }

    public boolean canBlockDamage(ItemStack shield, DamageSource source) {
        boolean flag;
        boolean bl = flag = source.isUnblockable() && !(source instanceof DamageUtils.DamageSourceArmorBreak);
        if (this.toolMaterial == Item.ToolMaterial.WOOD) {
            return !flag;
        }
        return !flag || source.isMagicDamage() || source.isFireDamage() || source.isProjectile() && this.toolMaterial == Item.ToolMaterial.EMERALD;
    }

    public float onBlock(EntityPlayer player, ItemStack shield, DamageSource source, float damage) {
        ZSSPlayerInfo.get(player).onAttackBlocked(shield, damage);
        WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:hammer", 0.4f, 0.5f);
        float damageBlocked = damage;
        if (this.toolMaterial == Item.ToolMaterial.WOOD) {
            int dmg;
            if (source.isProjectile() && !source.isExplosion() && source.getSourceOfDamage() instanceof IProjectile) {
                if (ZSSMain.isBG2Enabled && player.getHeldItem() == shield && shield.getItem() instanceof IArrowCatcher && ((IArrowCatcher)shield.getItem()).catchArrow(shield, player, (IProjectile)source.getSourceOfDamage())) {
                    ((InventoryPlayerBattle)player.inventory).hasChanged = true;
                }
            } else if (source instanceof IDamageAoE && ((IDamageAoE)source).isAoEDamage()) {
                damageBlocked *= this.magicReduction;
            }
            if ((dmg = Math.round(source.isFireDamage() ? damage + 10.0f : damage - 2.0f)) > 0) {
                shield.damageItem(dmg, (EntityLivingBase)player);
                if (shield.stackSize <= 0) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)shield);
                    if (ZSSMain.isBG2Enabled && BattlegearUtils.isPlayerInBattlemode((EntityPlayer)player)) {
                        BattlegearUtils.setPlayerOffhandItem((EntityPlayer)player, null);
                    } else {
                        player.destroyCurrentEquippedItem();
                    }
                }
            }
        } else if (this.toolMaterial == Item.ToolMaterial.EMERALD) {
            if (source.isProjectile() && !source.isExplosion() && source.getSourceOfDamage() != null) {
                float chance;
                float f = chance = source.isMagicDamage() ? 0.33333334f : 1.0f;
                if (source.getSourceOfDamage() instanceof IReflectable) {
                    ((IReflectable)source.getSourceOfDamage()).getReflectChance(shield, player, source.getEntity());
                }
                if (player.worldObj.rand.nextFloat() < chance) {
                    Entity projectile = null;
                    try {
                        projectile = (Entity)source.getSourceOfDamage().getClass().getConstructor(World.class).newInstance(player.worldObj);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (projectile != null) {
                        NBTTagCompound data = new NBTTagCompound();
                        source.getSourceOfDamage().writeToNBT(data);
                        projectile.readFromNBT(data);
                        projectile.getEntityData().setBoolean("isReflected", true);
                        projectile.posX -= projectile.motionX;
                        projectile.posY -= projectile.motionY;
                        projectile.posZ -= projectile.motionZ;
                        double motionX = -MathHelper.sin((float)(player.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(player.rotationPitch / 180.0f * (float)Math.PI));
                        double motionZ = MathHelper.cos((float)(player.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(player.rotationPitch / 180.0f * (float)Math.PI));
                        double motionY = -MathHelper.sin((float)(player.rotationPitch / 180.0f * (float)Math.PI));
                        TargetUtils.setEntityHeading(projectile, motionX, motionY, motionZ, 1.0f, 2.0f + 20.0f * player.worldObj.rand.nextFloat(), false);
                        if (projectile instanceof IReflectable) {
                            ((IReflectable)projectile).onReflected(shield, player, source.getEntity(), source.getSourceOfDamage());
                        }
                        player.worldObj.spawnEntityInWorld(projectile);
                    }
                } else if (source.isUnblockable() || source instanceof IDamageAoE && ((IDamageAoE)source).isAoEDamage()) {
                    damageBlocked *= this.magicReduction;
                }
            }
        } else if (source.isUnblockable() || source instanceof IDamageAoE && ((IDamageAoE)source).isAoEDamage()) {
            damageBlocked *= this.magicReduction;
        }
        return damage - damageBlocked;
    }

    @Override
    public float getExhaustion() {
        return 0.3f;
    }

    @Override
    public int getSwingSpeed() {
        return 10;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.block;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity target) {
        if (target instanceof EntityLivingBase) {
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:hammer", 0.4f, 0.5f);
            TargetUtils.knockTargetBack((EntityLivingBase)target, (EntityLivingBase)player);
        }
        return true;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (ZSSPlayerInfo.get(player).canBlock()) {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (this.toolMaterial == Item.ToolMaterial.EMERALD && player.getHeldItem() != null && ZSSPlayerInfo.get(player).canBlock()) {
            Vec3 vec3 = player.getLookVec();
            double dx = player.posX + vec3.xCoord * 2.0;
            double dy = player.posY + (double)player.getEyeHeight() + vec3.yCoord * 2.0;
            double dz = player.posZ + vec3.zCoord * 2.0;
            List list = player.worldObj.getEntitiesWithinAABB(EntityFireball.class, AxisAlignedBB.getBoundingBox((double)(dx - 1.0), (double)(dy - 1.0), (double)(dz - 1.0), (double)(dx + 1.0), (double)(dy + 1.0), (double)(dz + 1.0)));
            for (EntityFireball fireball : list) {
                DamageSource source = DamageSource.causeFireballDamage((EntityFireball)fireball, (Entity)fireball.shootingEntity);
                if (!this.canBlockDamage(stack, source) || !fireball.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)player), 1.0f)) continue;
                fireball.getEntityData().setBoolean("isReflected", true);
                ZSSPlayerInfo.get(player).onAttackBlocked(stack, 1.0f);
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:hammer", 0.4f, 0.5f);
                break;
            }
        }
    }

    public int getItemEnchantability() {
        return 0;
    }

    public boolean getIsRepairable(ItemStack toRepair, ItemStack stack) {
        return toRepair.isItemStackDamageable() && stack.getItem() == this.toolMaterial.func_150995_f();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBackIcon() {
        return this.backIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
        this.backIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_back");
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc.0")));
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        if (PlayerUtils.hasItem(player, ZSSItems.swordMasterTrue)) {
            item.setDead();
            player.triggerAchievement((StatBase)ZSSAchievements.shieldMirror);
            WorldUtils.spawnItemWithRandom(core.getWorldObj(), new ItemStack(ZSSItems.shieldMirror), core.xCoord, core.yCoord + 2, core.zCoord);
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else {
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.fairy.laugh.sword", new Object[0]);
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return this == ZSSItems.shieldHylian;
    }

    @Optional.Method(modid="battlegear2")
    public void setArrowCount(ItemStack stack, int count) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        stack.getTagCompound().setShort("arrows", (short)Math.min(count, Short.MAX_VALUE));
    }

    @Optional.Method(modid="battlegear2")
    public int getArrowCount(ItemStack stack) {
        return stack.hasTagCompound() ? (int)stack.getTagCompound().getShort("arrows") : 0;
    }

    @Optional.Method(modid="battlegear2")
    public boolean catchArrow(ItemStack shield, EntityPlayer player, IProjectile projectile) {
        if (this.toolMaterial == Item.ToolMaterial.WOOD && projectile instanceof EntityArrow) {
            this.setArrowCount(shield, this.getArrowCount(shield) + 1);
            player.setArrowCountInEntity(player.getArrowCountInEntity() - 1);
            ((EntityArrow)projectile).setDead();
            return true;
        }
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack item) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public float getDecayRate(ItemStack shield) {
        return this.bg2DecayRate;
    }

    @Optional.Method(modid="battlegear2")
    public float getRecoveryRate(ItemStack shield) {
        return this.bg2RecoveryRate;
    }

    @Optional.Method(modid="battlegear2")
    public boolean canBlock(ItemStack shield, DamageSource source) {
        return this.canBlockDamage(shield, source);
    }

    @Optional.Method(modid="battlegear2")
    public float getDamageDecayRate(ItemStack shield, float amount) {
        return 0.0f;
    }

    @Optional.Method(modid="battlegear2")
    public float getBlockAngle(ItemStack shield) {
        return 60.0f;
    }

    @Optional.Method(modid="battlegear2")
    public int getBashTimer(ItemStack shield) {
        return 10;
    }

    @Optional.Method(modid="battlegear2")
    public void blockAnimation(EntityPlayer player, float amount) {
    }

    @Optional.Method(modid="battlegear2")
    public float getDamageReduction(ItemStack shield, DamageSource source) {
        return 0.0f;
    }
}

