/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.buff.BuffBase;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.item.ItemDrinkable;

public class ItemZeldaPotion
extends ItemDrinkable
implements IUnenchantable {
    private final float restoreHP;
    private final float restoreMP;
    private BuffBase buff;
    private int minutes;
    private int seconds;
    private float buffProbability;

    public ItemZeldaPotion(String name) {
        this(name, 0.0f, 0.0f);
    }

    public ItemZeldaPotion(String name, float restoreHP, float restoreMP) {
        super(name);
        this.restoreHP = restoreHP;
        this.restoreMP = restoreMP;
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    @Override
    public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
        if (!player.capabilities.isCreativeMode) {
            --stack.stackSize;
        }
        world.playSoundAtEntity((Entity)player, "random.burp", 0.5f, world.rand.nextFloat() * 0.1f + 0.9f);
        player.heal(this.restoreHP);
        ZSSPlayerInfo.get(player).restoreMagic(this.restoreMP);
        if (this.buff != null && world.rand.nextFloat() < this.buffProbability) {
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(new BuffBase(this.buff));
        }
        return super.onEaten(stack, world, player);
    }

    public ItemZeldaPotion setBuffEffect(Buff buffEnum, int duration, int amplifier, float probability) {
        this.buff = new BuffBase(buffEnum, duration, amplifier);
        this.minutes = duration / 1200;
        this.seconds = duration % 1200;
        this.buffProbability = probability;
        return this;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        if (this.restoreHP > 0.0f) {
            list.add(EnumChatFormatting.YELLOW + StatCollector.translateToLocalFormatted((String)"tooltip.zss.restore_hp", (Object[])new Object[]{String.format("%.0f", Float.valueOf(this.restoreHP / 2.0f))}));
        }
        if (this.restoreMP > 0.0f) {
            list.add(EnumChatFormatting.GREEN + StatCollector.translateToLocalFormatted((String)"tooltip.zss.restore_mp", (Object[])new Object[]{MathHelper.floor_float((float)this.restoreMP)}));
        }
        if (this.buff != null) {
            list.add(EnumChatFormatting.GRAY + StatCollector.translateToLocalFormatted((String)"tooltip.zss.buff", (Object[])new Object[]{this.buff.getBuff().getName(), this.minutes, String.format("%02d", this.seconds)}));
            if (this.buffProbability < 1.0f) {
                list.add(EnumChatFormatting.GREEN + StatCollector.translateToLocalFormatted((String)"tooltip.zss.buff_chance", (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.buffProbability * 100.0f))}));
            }
            list.add(EnumChatFormatting.YELLOW + StatCollector.translateToLocalFormatted((String)"tooltip.zss.buff_amplifier", (Object[])new Object[]{this.buff.getAmplifier()}));
        }
    }
}

