/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityWhip;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ItemWhip
extends Item
implements IFairyUpgrade {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemWhip() {
        this.setFull3D();
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    public IWhipBlock.WhipType getType(ItemStack stack) {
        return this.getType(stack.getItemDamage());
    }

    public IWhipBlock.WhipType getType(int damage) {
        return damage > -1 ? IWhipBlock.WhipType.values()[damage % IWhipBlock.WhipType.values().length] : IWhipBlock.WhipType.WHIP_SHORT;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.block;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 32000;
    }

    public boolean isItemTool(ItemStack stack) {
        return true;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        EntityWhip whip = new EntityWhip(player.worldObj, (EntityLivingBase)player);
        whip.setThrower(player);
        whip.setType(this.getType(stack));
        if (!player.worldObj.isRemote) {
            player.worldObj.spawnEntityInWorld((Entity)whip);
            player.worldObj.playSoundAtEntity((Entity)player, "zeldaswordskills:whip", 0.4f, 1.0f);
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.worldObj.isRemote && entity.getClass() == EntityVillager.class) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.getRecipes(player);
            if (villager.getProfession() == TradeHandler.EnumVillager.BUTCHER.ordinal() && trades != null) {
                switch (this.getType(stack)) {
                    case WHIP_SHORT: {
                        MerchantRecipe trade = new MerchantRecipe(new ItemStack((Item)this, 1, IWhipBlock.WhipType.WHIP_SHORT.ordinal()), new ItemStack(Items.emerald, 64), new ItemStack((Item)this, 1, IWhipBlock.WhipType.WHIP_LONG.ordinal()));
                        if (MerchantRecipeHelper.addUniqueTrade(trades, trade)) {
                            PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.upgrade.new", new Object[0]);
                            break;
                        }
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.upgrade.old", new Object[0]);
                        break;
                    }
                    case WHIP_LONG: {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.long", new Object[0]);
                        break;
                    }
                    case WHIP_MAGIC: {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.magic", new Object[0]);
                    }
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.sorry", new Object[0]);
            }
        } else if (!player.worldObj.isRemote && entity instanceof INpc) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.sorry", new Object[0]);
        }
        return true;
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        if (this.getType(item.getEntityItem()) == IWhipBlock.WhipType.WHIP_LONG && core.consumeRupees(320)) {
            item.setDead();
            WorldUtils.spawnItemWithRandom(core.getWorldObj(), new ItemStack(ZSSItems.whip, 1, IWhipBlock.WhipType.WHIP_MAGIC.ordinal()), core.xCoord, core.yCoord + 2, core.zCoord);
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else {
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.fairy.laugh.unworthy", new Object[0]);
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return this.getType(stack) != IWhipBlock.WhipType.WHIP_MAGIC;
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.getUnlocalizedName() + "." + stack.getItemDamage();
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < IWhipBlock.WhipType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int type) {
        switch (this.getType(type)) {
            case WHIP_MAGIC: {
                return this.iconArray[1];
            }
        }
        return this.iconArray[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.iconArray = new IIcon[2];
        this.iconArray[0] = register.registerIcon("zeldaswordskills:whip");
        this.iconArray[1] = register.registerIcon("zeldaswordskills:whip_magic");
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip.zss.whip.desc." + this.getType(stack).ordinal())));
    }
}

