/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.INpc;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import zeldaswordskills.api.entity.NpcHelper;
import zeldaswordskills.api.item.IRightClickEntity;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSVillagerInfo;
import zeldaswordskills.entity.npc.EntityNpcMaskTrader;
import zeldaswordskills.entity.npc.EntityNpcOrca;
import zeldaswordskills.entity.player.quests.IQuest;
import zeldaswordskills.entity.player.quests.QuestBase;
import zeldaswordskills.entity.player.quests.QuestBiggoronSword;
import zeldaswordskills.entity.player.quests.QuestMaskSales;
import zeldaswordskills.entity.player.quests.QuestMaskShop;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedAddItem;
import zeldaswordskills.util.TimedChatDialogue;

public class ItemTreasure
extends Item
implements IRightClickEntity,
IUnenchantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemTreasure() {
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabMisc);
    }

    public int getItemStackLimit(ItemStack stack) {
        return Treasures.byDamage(stack.getItemDamage()).getMaxStackSize();
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (player.worldObj.isRemote) {
            return true;
        }
        if (entity instanceof EntityNpcMaskTrader && ((EntityNpcMaskTrader)entity).checkShopStatus(player, false, true)) {
            return true;
        }
        if (entity instanceof EntityVillager && Event.Result.DEFAULT == NpcHelper.convertVillager(player, (EntityVillager)entity, false)) {
            this.handleTrade(stack, player, entity, true);
        } else if (entity instanceof INpc) {
            this.handleTrade(stack, player, entity, true);
        }
        return true;
    }

    @Override
    public boolean onRightClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return !player.worldObj.isRemote && this.handleTrade(stack, player, entity, false);
    }

    private boolean handleTrade(ItemStack stack, EntityPlayer player, Entity entity, boolean isLeftClick) {
        Treasures treasure = Treasures.byDamage(stack.getItemDamage());
        if (treasure.isBiggoronTrade()) {
            return this.handleBiggoronQuest(stack, player, entity, isLeftClick);
        }
        if (entity instanceof EntityVillager) {
            if (treasure == Treasures.ZELDAS_LETTER) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure." + treasure.name + (((EntityVillager)entity).isChild() ? ".child" : ".fail") + (isLeftClick ? ".give" : ".show"), new Object[0]);
            } else if (!this.handleVillagerTrade(stack, player, (EntityVillager)entity, isLeftClick)) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure." + treasure.uninterested + ".uninterested", new Object[0]);
            }
            return true;
        }
        if (entity instanceof INpc) {
            if (entity instanceof EntityAgeable && ((EntityAgeable)entity).isChild()) {
                this.handleChildTrade(stack, player, isLeftClick);
            } else if (treasure == Treasures.ZELDAS_LETTER && entity instanceof EntityNpcMaskTrader) {
                ZSSQuests quests = ZSSQuests.get(player);
                if (quests.hasCompleted(QuestMaskSales.class)) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.shop.open", new Object[0]);
                } else {
                    IQuest quest = quests.get(QuestMaskShop.class);
                    if (quest != null) {
                        IChatComponent hint = quest.getHint(player, new Object[0]);
                        if (hint != null) {
                            player.addChatMessage(hint);
                        }
                    } else {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.shop.hint." + itemRand.nextInt(4), new Object[0]);
                    }
                }
            } else if (treasure == Treasures.KNIGHTS_CREST && entity instanceof EntityNpcOrca) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure." + treasure.uninterested + ".uninterested.orca", new Object[0]);
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure." + treasure.uninterested + ".uninterested", new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean handleVillagerTrade(ItemStack stack, EntityPlayer player, EntityVillager villager, boolean isLeftClick) {
        Treasures treasure = Treasures.byDamage(stack.getItemDamage());
        ZSSVillagerInfo villagerInfo = ZSSVillagerInfo.get(villager);
        MerchantRecipe trade = villagerInfo.getTreasureTrade(treasure);
        villager.playLivingSound();
        if (villager.isChild()) {
            this.handleChildTrade(stack, player, isLeftClick);
        } else {
            if (trade == null) {
                return false;
            }
            if (isLeftClick) {
                ItemStack required = trade.getSecondItemToBuy();
                if (required == null || PlayerUtils.consumeInventoryItem(player, required, required.stackSize)) {
                    PlayerUtils.playSound(player, "zeldaswordskills:success", 1.0f, 1.0f);
                    if (stack.stackSize > 1) {
                        --stack.stackSize;
                        PlayerUtils.addItemToInventory(player, trade.getItemToSell().copy());
                    } else {
                        player.setCurrentItemOrArmor(0, trade.getItemToSell().copy());
                    }
                    if (villagerInfo.isHunter()) {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure.hunter.trade." + itemRand.nextInt(4), new Object[0]);
                    } else {
                        new TimedChatDialogue(player, 0, 500, new IChatComponent[]{new ChatComponentTranslation("chat.zss.treasure." + treasure.name + ".trade", new Object[0]), new ChatComponentTranslation("chat.zss.treasure.generic.received", new Object[]{new ChatComponentTranslation(trade.getItemToSell().getUnlocalizedName() + ".name", new Object[0])})});
                    }
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure.generic.trade.fail", required.stackSize, new ChatComponentTranslation(required.getUnlocalizedName() + ".name", new Object[0]));
                }
            } else if (villagerInfo.isHunter()) {
                new TimedChatDialogue(player, 0, 1000, new IChatComponent[]{new ChatComponentTranslation("chat.zss.treasure.hunter.interested.0", new Object[]{new ChatComponentTranslation(trade.getItemToBuy().getUnlocalizedName() + ".name", new Object[0])}), new ChatComponentTranslation("chat.zss.treasure.hunter.interested.1", new Object[]{trade.getItemToSell().stackSize})});
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure.generic.interested", new ChatComponentTranslation(trade.getItemToSell().getUnlocalizedName() + ".name", new Object[0]));
            }
        }
        return true;
    }

    private boolean handleBiggoronQuest(ItemStack stack, EntityPlayer player, Entity entity, boolean isLeftClick) {
        ZSSQuests quests = ZSSQuests.get(player);
        IQuest quest = quests.get(QuestBiggoronSword.class);
        if (quest == null) {
            quest = new QuestBiggoronSword();
            quests.add(quest);
        }
        if (QuestBase.checkQuestProgress(player, quest, QuestBase.DEFAULT_QUEST_HANDLER, entity, isLeftClick)) {
            return true;
        }
        if (entity instanceof EntityVillager && ((EntityVillager)entity).isChild()) {
            this.handleChildTrade(stack, player, isLeftClick);
            return true;
        }
        return false;
    }

    private void handleChildTrade(ItemStack stack, EntityPlayer player, boolean isLeftClick) {
        PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure.generic.child" + (isLeftClick ? ".give" : ".show"), new Object[0]);
        if (isLeftClick) {
            player.setCurrentItemOrArmor(0, null);
            if (itemRand.nextFloat() < 0.99f || Treasures.byDamage(stack.getItemDamage()).isBiggoronTrade()) {
                new TimedChatDialogue(player, 1500, 1250, new IChatComponent[]{new ChatComponentTranslation("chat.zss.treasure.generic.child.return", new Object[0])});
                new TimedAddItem(player, stack.copy(), 1500);
            } else {
                new TimedChatDialogue(player, 1500, 1250, new IChatComponent[]{new ChatComponentTranslation("chat.zss.treasure.generic.child.broken", new Object[0])});
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.iconArray[par1 % Treasures.values().length];
    }

    public String getUnlocalizedName(ItemStack stack) {
        return super.getUnlocalizedName() + "." + Treasures.byDamage((int)stack.getItemDamage()).name;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < Treasures.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.iconArray = new IIcon[Treasures.values().length];
        for (int i = 0; i < Treasures.values().length; ++i) {
            this.iconArray[i] = register.registerIcon("zeldaswordskills:" + Treasures.values()[i].name);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName(stack).substring(5) + ".desc.0")));
    }

    public static enum Treasures {
        CLAIM_CHECK("claim_check", true),
        COJIRO("cojiro", true),
        EVIL_CRYSTAL("evil_crystal"),
        EYE_DROPS("eye_drops", true),
        EYEBALL_FROG("eyeball_frog", true),
        GORON_SWORD("goron_sword", true),
        JELLY_BLOB("jelly_blob", "generic", 32, 64, false),
        MONSTER_CLAW("monster_claw", "generic", 24, 64, false),
        ODD_MUSHROOM("odd_mushroom", true),
        ODD_POTION("odd_potion", true),
        POACHER_SAW("poacher_saw", true),
        POCKET_EGG("pocket_egg", true),
        PRESCRIPTION("prescription", true),
        TENTACLE("tentacle", "generic", 16, 64, true),
        ZELDAS_LETTER("zeldas_letter"),
        KNIGHTS_CREST("knights_crest", "knights_crest", 32, 64, false);

        public final String name;
        public final String uninterested;
        private final int value;
        private final int maxStackSize;
        private final boolean isBiggoronTrade;

        private Treasures(String name) {
            this(name, "generic", 0, 1, false);
        }

        private Treasures(String name, boolean isBiggoronTrade) {
            this(name, "generic", 0, 1, isBiggoronTrade);
        }

        private Treasures(String name, int value) {
            this(name, "generic", value, 1, false);
        }

        private Treasures(String name, String uninterested, int value, int maxStackSize, boolean isBiggoronTrade) {
            this.name = name;
            this.uninterested = uninterested;
            this.value = value;
            this.maxStackSize = maxStackSize;
            this.isBiggoronTrade = isBiggoronTrade;
        }

        public boolean canSell() {
            return this.value > 0;
        }

        public int getValue() {
            return this.value;
        }

        public int getMaxStackSize() {
            return this.maxStackSize;
        }

        public boolean isBiggoronTrade() {
            return this.isBiggoronTrade;
        }

        public static Treasures byDamage(int damage) {
            return Treasures.values()[damage % Treasures.values().length];
        }
    }
}

