/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.api.item.IZoom;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntitySeedShot;
import zeldaswordskills.item.ICyclableItem;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ItemSlingshot
extends Item
implements ICyclableItem,
IFairyUpgrade,
IUnenchantable,
IZoom {
    protected final int seedsFired;
    protected final float spread;
    private static final Map<Item, EntitySeedShot.SeedType> seedToType = new HashMap<Item, EntitySeedShot.SeedType>();
    private static final Map<EntitySeedShot.SeedType, Item> typeToSeed = new EnumMap<EntitySeedShot.SeedType, Item>(EntitySeedShot.SeedType.class);

    public static void initializeSeeds() {
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.BOMB, ZSSItems.bombFlowerSeed);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.COCOA, Items.dye);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.DEKU, ZSSItems.dekuNut);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.GRASS, Items.wheat_seeds);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.MELON, Items.melon_seeds);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.NETHERWART, Items.nether_wart);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.PUMPKIN, Items.pumpkin_seeds);
    }

    private static void addSeedMapping(EntitySeedShot.SeedType type, Item item) {
        seedToType.put(item, type);
        typeToSeed.put(type, item);
    }

    public ItemSlingshot() {
        this(1, 0.0f);
    }

    public ItemSlingshot(int seedsFired, float spread) {
        this.seedsFired = seedsFired;
        this.spread = spread;
        this.setFull3D();
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabCombat);
    }

    public Mode getMode(EntityPlayer player) {
        return Mode.values()[ZSSPlayerInfo.get((EntityPlayer)player).slingshotMode % Mode.values().length];
    }

    private void setMode(EntityPlayer player, Mode mode) {
        ZSSPlayerInfo.get((EntityPlayer)player).slingshotMode = mode.ordinal();
    }

    @Override
    public void nextItemMode(ItemStack stack, EntityPlayer player) {
        if (!player.isUsingItem()) {
            this.setMode(player, this.getMode(player).next());
        }
    }

    @Override
    public void prevItemMode(ItemStack stack, EntityPlayer player) {
        if (!player.isUsingItem()) {
            this.setMode(player, this.getMode(player).prev());
        }
    }

    @Override
    public int getCurrentMode(ItemStack stack, EntityPlayer player) {
        return this.getMode(player).ordinal();
    }

    @Override
    public void setCurrentMode(ItemStack stack, EntityPlayer player, int mode) {
        this.setMode(player, Mode.values()[mode % Mode.values().length]);
    }

    @Override
    public ItemStack getRenderStackForMode(ItemStack stack, EntityPlayer player) {
        ItemStack ret = this.getMode(player).getSeedStack();
        if (ret != null) {
            ret.stackSize = 0;
            for (ItemStack inv : player.inventory.mainInventory) {
                if (inv == null || inv.getItem() != ret.getItem() || inv.getItemDamage() != ret.getItemDamage()) continue;
                ret.stackSize += inv.stackSize;
                if (ret.stackSize <= 98) continue;
                ret.stackSize = 99;
                break;
            }
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getMaxZoomTime() {
        return 20.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getZoomFactor() {
        return 0.15f;
    }

    public int getItemEnchantability() {
        return 0;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.bow;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (this.hasSeeds(player)) {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        }
        return stack;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int ticksUsed) {
        int charge = this.getMaxItemUseDuration(stack) - ticksUsed;
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        EntitySeedShot.SeedType type = this.getSeedType(player);
        if (f < 0.3f || type == EntitySeedShot.SeedType.NONE) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        for (int i = 0; i < this.seedsFired; ++i) {
            EntitySeedShot seedShot = new EntitySeedShot(world, (EntityLivingBase)player, f, i + 1, this.spread).setType(type);
            if (f == 1.0f) {
                seedShot.setIsCritical(true);
            }
            float factor = this.seedsFired == 1 ? 2.2f : (this.seedsFired < 4 ? 1.4f : 1.0f);
            float damage = type.getDamage();
            int k = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)stack);
            if (k > 0) {
                damage += (float)k * 0.25f + 0.25f;
            }
            seedShot.setDamage(damage * factor);
            int l = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)stack);
            seedShot.setKnockback(l > 0 ? l : (type == EntitySeedShot.SeedType.MELON ? 1 : 0));
            if (type == EntitySeedShot.SeedType.NETHERWART || EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)stack) > 0) {
                seedShot.setFire(100);
            }
            if (world.isRemote) continue;
            world.spawnEntityInWorld((Entity)seedShot);
        }
        world.playSoundAtEntity((Entity)player, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        if (!player.capabilities.isCreativeMode) {
            Item seed;
            PlayerUtils.consumeInventoryItem(player, seed, (seed = typeToSeed.get((Object)type)) == Items.dye ? 3 : 0, 1);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.worldObj.isRemote && entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.getRecipes(player);
            if (trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.copy(), new ItemStack(Items.emerald, 6 + 2 * this.seedsFired));
                if (player.worldObj.rand.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.0", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
        return true;
    }

    protected boolean hasSeeds(EntityPlayer player) {
        if (player.capabilities.isCreativeMode) {
            return true;
        }
        return this.getSeedType(player) != EntitySeedShot.SeedType.NONE;
    }

    protected EntitySeedShot.SeedType getSeedType(EntityPlayer player) {
        EntitySeedShot.SeedType selected = this.getMode(player).type;
        for (ItemStack stack : player.inventory.mainInventory) {
            EntitySeedShot.SeedType type;
            if (stack == null || !seedToType.containsKey(stack.getItem()) || (type = seedToType.get(stack.getItem())) == EntitySeedShot.SeedType.COCOA && stack.getItemDamage() != 3 || selected != null && type != selected) continue;
            return type;
        }
        return player.capabilities.isCreativeMode ? (selected == null ? EntitySeedShot.SeedType.GRASS : selected) : EntitySeedShot.SeedType.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        ItemStack mode;
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.slingshot.desc.0"));
        if (this.seedsFired > 1) {
            list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocalFormatted((String)"tooltip.zss.slingshot.desc.1", (Object[])new Object[]{this.seedsFired}));
        }
        if ((mode = this.getMode(player).getSeedStack()) != null) {
            list.add(EnumChatFormatting.YELLOW + StatCollector.translateToLocalFormatted((String)"tooltip.zss.mode", (Object[])new Object[]{mode.getDisplayName()}));
        }
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        ItemStack stack = item.getEntityItem();
        if (stack.getItem() == ZSSItems.slingshot && core.consumeRupees(Config.getSlingshotCostOne())) {
            item.setDead();
            player.triggerAchievement((StatBase)ZSSAchievements.fairySlingshot);
            WorldUtils.spawnItemWithRandom(core.getWorldObj(), new ItemStack(ZSSItems.scattershot), core.xCoord, core.yCoord + 2, core.zCoord);
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else if (stack.getItem() == ZSSItems.scattershot && core.consumeRupees(Config.getSlingshotCostTwo())) {
            item.setDead();
            player.triggerAchievement((StatBase)ZSSAchievements.fairySupershot);
            WorldUtils.spawnItemWithRandom(core.getWorldObj(), new ItemStack(ZSSItems.supershot), core.xCoord, core.yCoord + 2, core.zCoord);
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else {
            this.addFairyEnchantments(stack, player, core);
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return true;
    }

    private void addFairyEnchantments(ItemStack stack, EntityPlayer player, TileEntityDungeonCore core) {
        int newLvl;
        byte hearts = ZSSPlayerSkills.get(player).getSkillLevel(SkillBase.bonusHeart);
        int divisor = this.seedsFired == 1 ? 5 : (this.seedsFired < 4 ? 7 : 10);
        int lvl = newLvl = Math.min(hearts / divisor, Enchantment.power.getMaxLevel());
        boolean flag = false;
        boolean playSound = false;
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("ench")) {
            NBTTagList enchList = (NBTTagList)stack.getTagCompound().getTag("ench");
            for (int i = 0; i < enchList.tagCount(); ++i) {
                NBTTagCompound compound = enchList.getCompoundTagAt(i);
                if (compound.getShort("id") != Enchantment.power.effectId) continue;
                short oldLvl = compound.getShort("lvl");
                for (lvl = newLvl - oldLvl; lvl > 0 && core.consumeRupees(divisor * 2); --lvl) {
                }
                if ((newLvl -= lvl) > oldLvl) {
                    enchList.removeTag(i);
                    stack.addEnchantment(Enchantment.power, newLvl);
                    playSound = true;
                }
                flag = true;
                break;
            }
        }
        if (!flag) {
            while (lvl > 0 && core.consumeRupees(divisor * 2)) {
                --lvl;
            }
            if ((newLvl -= lvl) > 0) {
                playSound = true;
                stack.addEnchantment(Enchantment.power, newLvl);
            }
        }
        if (playSound) {
            player.triggerAchievement((StatBase)ZSSAchievements.fairyEnchantment);
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:fairy_blessing", 1.0f, 1.0f);
        } else {
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.fairy.laugh.unworthy", new Object[0]);
        }
    }

    public static enum Mode {
        DEFAULT(null),
        DEKU(EntitySeedShot.SeedType.DEKU),
        BOMB(EntitySeedShot.SeedType.BOMB),
        COCOA(EntitySeedShot.SeedType.COCOA),
        GRASS(EntitySeedShot.SeedType.GRASS),
        MELON(EntitySeedShot.SeedType.MELON),
        PUMPKIN(EntitySeedShot.SeedType.PUMPKIN),
        NETHERWART(EntitySeedShot.SeedType.NETHERWART);

        private ItemStack seedStack;
        private final EntitySeedShot.SeedType type;

        private Mode(EntitySeedShot.SeedType type) {
            this.type = type;
        }

        public ItemStack getSeedStack() {
            Item item;
            if (this.type != null && (item = (Item)typeToSeed.get((Object)this.type)) != null) {
                this.seedStack = new ItemStack(item, 1, item == Items.dye ? 3 : 0);
            }
            return this.seedStack;
        }

        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }

        public Mode prev() {
            return Mode.values()[((this.ordinal() == 0 ? Mode.values().length : this.ordinal()) - 1) % Mode.values().length];
        }
    }
}

