/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemSkillOrb
extends Item
implements IUnenchantable {
    @SideOnly(value=Side.CLIENT)
    private List<IIcon> icons;

    public ItemSkillOrb() {
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabSkills);
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        SkillBase skill;
        if (!player.worldObj.isRemote && (skill = SkillBase.getSkill(stack.getItemDamage())) != null) {
            ZSSPlayerSkills skills = ZSSPlayerSkills.get(player);
            if (skills.grantSkill(skill)) {
                world.playSoundAtEntity((Entity)player, "zeldaswordskills:levelup", 1.0f, 1.0f);
                PlayerUtils.sendTranslatedChat(player, "chat.zss.skill.levelup", new ChatComponentTranslation(skill.getTranslationString(), new Object[0]), skills.getSkillLevel(skill));
                if (skill == SkillBase.bonusHeart) {
                    player.triggerAchievement((StatBase)ZSSAchievements.skillHeart);
                    if (skills.getSkillLevel(skill) > 19) {
                        player.triggerAchievement((StatBase)ZSSAchievements.skillHeartsGalore);
                    } else if (skills.getSkillLevel(skill) > 9) {
                        player.triggerAchievement((StatBase)ZSSAchievements.skillHeartBar);
                    }
                } else if (skill == SkillBase.swordBasic && skills.getSkillLevel(skill) == 1) {
                    player.triggerAchievement((StatBase)ZSSAchievements.skillBasic);
                } else if (skills.getSkillLevel(skill) == skill.getMaxLevel()) {
                    player.triggerAchievement((StatBase)ZSSAchievements.skillMaster);
                    boolean flag = true;
                    for (SkillBase check : SkillBase.getSkills()) {
                        if (check.getId() != SkillBase.bonusHeart.getId() && !(flag = skills.getSkillLevel(check) == check.getMaxLevel())) break;
                    }
                    if (flag) {
                        player.triggerAchievement((StatBase)ZSSAchievements.skillMasterAll);
                    }
                }
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.skill.maxlevel", new ChatComponentTranslation(skill.getTranslationString(), new Object[0]));
            }
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityVillager && !player.worldObj.isRemote) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.getRecipes(player);
            if (villager.getProfession() == 1 && trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.copy(), new ItemStack(Items.emerald, 16));
                if (player.worldObj.rand.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.1", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
        return true;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        SkillBase skill = SkillBase.getSkill(stack.getItemDamage());
        if (skill == SkillBase.bonusHeart) {
            return skill.getDisplayName();
        }
        return StatCollector.translateToLocalFormatted((String)(this.getUnlocalizedName() + ".name"), (Object[])new Object[]{skill == null ? "" : skill.getDisplayName()});
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        return this.icons.get(damage % this.icons.size());
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (SkillBase skill : SkillBase.getSkills()) {
            list.add(new ItemStack(item, 1, (int)skill.getId()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new ArrayList<IIcon>(SkillBase.getNumSkills());
        for (SkillBase skill : SkillBase.getSkills()) {
            this.icons.add(register.registerIcon(skill.getIconTexture()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (SkillBase.doesSkillExist(stack.getItemDamage())) {
            SkillBase skill = ZSSPlayerSkills.get(player).getPlayerSkill(SkillBase.getSkill(stack.getItemDamage()));
            if (skill != null && skill.getLevel() > 0) {
                if (skill.getId() != SkillBase.bonusHeart.getId()) {
                    list.add(EnumChatFormatting.GOLD + skill.getLevelDisplay(true));
                }
                list.addAll(skill.getTranslatedTooltip(player));
            } else {
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.skillorb.desc.0"));
            }
        }
    }
}

