/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.util.PlayerUtils;

public class ItemPendant
extends Item
implements IUnenchantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemPendant() {
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabMisc);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.worldObj.isRemote && entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            if (villager.getProfession() == 2) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.pendant.priest.0", new Object[0]);
                PlayerUtils.sendTranslatedChat(player, "chat.zss.pendant.priest.1", new Object[0]);
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.pendant.villager", new Object[0]);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.iconArray[PendantType.byDamage(par1).ordinal()];
    }

    public String getUnlocalizedName(ItemStack stack) {
        return super.getUnlocalizedName() + "_" + PendantType.byDamage((int)stack.getItemDamage()).unlocalizedName;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (PendantType type : PendantType.values()) {
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.iconArray = new IIcon[PendantType.values().length];
        for (PendantType type : PendantType.values()) {
            this.iconArray[type.ordinal()] = register.registerIcon("zeldaswordskills:pendant_" + type.unlocalizedName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.pendant.desc.0"));
    }

    public static enum PendantType {
        POWER("power", 1),
        WISDOM("wisdom", 2),
        COURAGE("courage", 4);

        public final String unlocalizedName;
        public final int bitFlag;

        private PendantType(String name, int bitFlag) {
            this.unlocalizedName = name;
            this.bitFlag = bitFlag;
        }

        public static PendantType byDamage(int damage) {
            return PendantType.values()[damage % PendantType.values().length];
        }
    }
}

