/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import zeldaswordskills.api.item.IRightClickEntity;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemMiscZSS
extends Item
implements IRightClickEntity,
IUnenchantable {
    protected final int sellPrice;

    public ItemMiscZSS(int price) {
        this.setMaxDamage(0);
        this.canRepair = false;
        this.sellPrice = price;
        this.setCreativeTab(ZSSCreativeTabs.tabMisc);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.worldObj.isRemote && entity instanceof EntityVillager) {
            this.handleTrade(stack, player, (EntityVillager)entity);
        }
        return true;
    }

    @Override
    public boolean onRightClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.worldObj.isRemote && entity instanceof EntityVillager) {
            this.handleTrade(stack, player, (EntityVillager)entity);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc.0")));
    }

    protected void handleTrade(ItemStack stack, EntityPlayer player, EntityVillager villager) {
        MerchantRecipeList trades = villager.getRecipes(player);
        if (villager.isChild()) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.child", new Object[0]);
        } else if (villager.getClass() != EntityVillager.class) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
        } else if (trades != null && this.sellPrice > 0) {
            MerchantRecipe trade = new MerchantRecipe(stack.copy(), new ItemStack(Items.emerald, this.sellPrice));
            if (player.worldObj.rand.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.0", new Object[0]);
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
            }
        } else {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
        }
    }
}

