/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.ILiftable;
import zeldaswordskills.api.item.IHandleToss;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.item.ZSSItems;

public class ItemHeldBlock
extends Item
implements IHandleToss,
IUnenchantable {
    public ItemHeldBlock() {
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setTextureName("stone");
    }

    public static ItemStack getBlockStack(Block block, int metadata, ItemStack gauntlets) {
        ItemStack stack = new ItemStack(ZSSItems.heldBlock);
        stack.setTagCompound(new NBTTagCompound());
        stack.getTagCompound().setInteger("blockId", Block.getIdFromBlock((Block)block));
        stack.getTagCompound().setInteger("metadata", metadata);
        if (gauntlets != null) {
            stack.getTagCompound().setTag("gauntlets", (NBTBase)gauntlets.writeToNBT(new NBTTagCompound()));
        }
        return stack;
    }

    public Block getBlockFromStack(ItemStack stack) {
        return stack.hasTagCompound() ? Block.getBlockById((int)stack.getTagCompound().getInteger("blockId")) : null;
    }

    public int getMetaFromStack(ItemStack stack) {
        return stack.hasTagCompound() ? stack.getTagCompound().getInteger("metadata") : 0;
    }

    public boolean dropHeldBlock(ItemStack stack, World world, EntityPlayer player) {
        int x = MathHelper.floor_double((double)player.posX);
        int y = MathHelper.floor_double((double)player.boundingBox.minY);
        int z = MathHelper.floor_double((double)player.posZ);
        int meta = this.getMetaFromStack(stack);
        Block block = this.getBlockFromStack(stack);
        if (block != null) {
            int dx;
            Vec3 vec3 = player.getLookVec();
            int n = Math.abs(vec3.xCoord) < 0.25 ? 0 : (dx = vec3.xCoord < 0.0 ? -1 : 1);
            int dz = Math.abs(vec3.zCoord) < 0.25 ? 0 : (vec3.zCoord < 0.0 ? -1 : 1);
            boolean flag = this.tryDropBlock(stack, world, x + dx, y + 1, z + dz, dx, dz, block, meta, 4);
            if (!flag) {
                flag = this.tryDropBlock(stack, world, x, y + 1, z, -dx, -dz, block, meta, 5);
            }
            if (!flag && !block.getMaterial().isSolid()) {
                flag = this.placeBlockAt(stack, player, world, x, y, z, 1, (float)player.posX, (float)player.posY, (float)player.posZ, block, meta);
            }
            if (flag) {
                world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.stepSound.getBreakSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
            }
            return flag;
        }
        return false;
    }

    private boolean tryDropBlock(ItemStack stack, World world, int x, int y, int z, int dx, int dz, Block block, int meta, int n) {
        boolean flag = false;
        for (int i = 0; i < n && !flag; ++i) {
            for (int j = 0; j < n - i && !flag; ++j) {
                for (int k = 0; k < 4 && !flag; ++k) {
                    flag = this.tryPlaceBlock(stack, world, x + dz * j, y - k, z + dx * j, block, meta, 1);
                    if (flag) continue;
                    flag = this.tryPlaceBlock(stack, world, x - dz * j, y - k, z - dx * j, block, meta, 1);
                }
            }
            x += dx;
            z += dz;
        }
        return flag;
    }

    private boolean tryPlaceBlock(ItemStack stack, World world, int x, int y, int z, Block block, int meta, int side) {
        int placedMeta;
        Block b = world.getBlock(x, y, z);
        if (world.getBlock(x, y - 1, z).func_149730_j() && b.isReplaceable((IBlockAccess)world, x, y, z) && world.canPlaceEntityOnSide(block, x, y, z, false, 1, null, stack) && world.setBlock(x, y, z, block, placedMeta = block.onBlockPlaced(world, x, y, z, 1, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, meta), 3)) {
            if (world.getBlock(x, y, z) == block) {
                block.onPostBlockPlaced(world, x, y, z, placedMeta);
                if (block instanceof ILiftable) {
                    ((ILiftable)block).onHeldBlockPlaced(world, stack, x, y, z, placedMeta);
                }
            }
            return true;
        }
        return false;
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (isHeld) {
            if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).capabilities.isFlying) {
                entity.motionX *= 0.25;
                entity.motionZ *= 0.25;
            }
        } else if (!world.isRemote && entity instanceof EntityPlayer && this.dropHeldBlock(stack, world, (EntityPlayer)entity)) {
            ItemStack gauntlets = stack.hasTagCompound() && stack.getTagCompound().hasKey("gauntlets") ? ItemStack.loadItemStackFromNBT((NBTTagCompound)stack.getTagCompound().getCompoundTag("gauntlets")) : null;
            ((EntityPlayer)entity).inventory.setInventorySlotContents(slot, gauntlets);
        }
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack stack) {
        return true;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block b = world.getBlock(x, y, z);
        if (b == Blocks.snow_layer) {
            side = 1;
        } else if (b != Blocks.vine && b != Blocks.tallgrass && b != Blocks.deadbush && !b.isReplaceable((IBlockAccess)world, x, y, z)) {
            switch (side) {
                case 0: {
                    --y;
                    break;
                }
                case 1: {
                    ++y;
                    break;
                }
                case 2: {
                    --z;
                    break;
                }
                case 3: {
                    ++z;
                    break;
                }
                case 4: {
                    --x;
                    break;
                }
                case 5: {
                    ++x;
                    break;
                }
            }
        }
        Block block = this.getBlockFromStack(stack);
        if (block == null || stack.stackSize == 0) {
            return false;
        }
        if (!player.canPlayerEdit(x, y, z, side, stack) && !(block instanceof ILiftable)) {
            return false;
        }
        if (y == 255 && block.getMaterial().isSolid()) {
            return false;
        }
        if (world.canPlaceEntityOnSide(block, x, y, z, false, side, null, stack)) {
            int meta = this.getMetaFromStack(stack);
            int placedMeta = block.onBlockPlaced(world, x, y, z, side, hitX, hitY, hitZ, meta);
            if (this.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, block, placedMeta)) {
                world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.stepSound.getBreakSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                ItemStack gauntlets = stack.hasTagCompound() && stack.getTagCompound().hasKey("gauntlets") ? ItemStack.loadItemStackFromNBT((NBTTagCompound)stack.getTagCompound().getCompoundTag("gauntlets")) : null;
                player.setCurrentItemOrArmor(0, gauntlets);
            }
            return true;
        }
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, Block block, int meta) {
        if (!world.setBlock(x, y, z, block, meta, 3)) {
            return false;
        }
        if (world.getBlock(x, y, z) == block) {
            block.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, stack);
            block.onPostBlockPlaced(world, x, y, z, meta);
            if (block instanceof ILiftable) {
                ((ILiftable)block).onHeldBlockPlaced(world, stack, x, y, z, meta);
            }
        }
        return true;
    }

    public String getUnlocalizedName(ItemStack stack) {
        Block block = this.getBlockFromStack(stack);
        return block != null ? block.getUnlocalizedName() : Blocks.stone.getUnlocalizedName();
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpriteNumber() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        Block block = this.getBlockFromStack(stack);
        return block != null ? block.getIcon(1, this.getMetaFromStack(stack)) : Blocks.stone.getIcon(1, 0);
    }

    @Override
    public void onItemTossed(EntityItem item, EntityPlayer player) {
        ItemStack stack = item.getEntityItem();
        if (this.dropHeldBlock(stack, player.getEntityWorld(), player)) {
            ItemStack gauntlets = stack.hasTagCompound() && stack.getTagCompound().hasKey("gauntlets") ? ItemStack.loadItemStackFromNBT((NBTTagCompound)stack.getTagCompound().getCompoundTag("gauntlets")) : null;
            player.setCurrentItemOrArmor(0, gauntlets);
            item.setDead();
        }
    }
}

