/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.api.IAllowItem;
import mods.battlegear2.api.ISheathed;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.entity.IParryModifier;
import zeldaswordskills.api.item.IArmorBreak;
import zeldaswordskills.api.item.ISmashBlock;
import zeldaswordskills.api.item.ISwingSpeed;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.api.item.IWeapon;
import zeldaswordskills.api.item.WeaponRegistry;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.handler.ZSSCombatEvents;
import zeldaswordskills.item.ISpawnParticles;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.PacketISpawnParticles;
import zeldaswordskills.util.WorldUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="mods.battlegear2.api.IAllowItem", modid="battlegear2", striprefs=true), @Optional.Interface(iface="mods.battlegear2.api.ISheathed", modid="battlegear2", striprefs=true)})
public class ItemHammer
extends Item
implements IArmorBreak,
IParryModifier,
ISmashBlock,
ISpawnParticles,
ISwingSpeed,
IWeapon,
IUnenchantable,
IAllowItem,
ISheathed {
    private final BlockWeight strength;
    private final float weaponDamage;
    private final float ignoreArmorAmount;

    public ItemHammer(BlockWeight strength, float damage, float ignoreArmor) {
        this.strength = strength;
        this.weaponDamage = damage;
        this.ignoreArmorAmount = ignoreArmor;
        this.setFull3D();
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabCombat);
    }

    public boolean func_150897_b(Block block) {
        return block instanceof ISmashable || block instanceof BlockBreakable;
    }

    @Override
    public float getOffensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return 0.4f;
    }

    @Override
    public float getDefensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return 0.0f;
    }

    @Override
    public float getPercentArmorIgnored() {
        return this.ignoreArmorAmount;
    }

    @Override
    public BlockWeight getSmashStrength(EntityPlayer player, ItemStack stack, Block block, int meta) {
        return block instanceof BlockBreakable ? this.strength.next() : this.strength;
    }

    @Override
    public void onBlockSmashed(EntityPlayer player, ItemStack stack, Block block, int meta, boolean wasSmashed) {
        if (!wasSmashed) {
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:hammer", 0.4f, 0.5f);
        }
    }

    @Override
    public float getExhaustion() {
        return this.weaponDamage / 16.0f;
    }

    @Override
    public int getSwingSpeed() {
        return 30;
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        WorldUtils.playSoundAtEntity((Entity)attacker, "zeldaswordskills:hammer", 0.4f, 0.5f);
        double dx = 0.15 * (attacker.posX - target.posX);
        double dz = 0.15 * (attacker.posZ - target.posZ);
        float f = MathHelper.sqrt_double((double)(dx * dx + dz * dz));
        if (f > 0.0f) {
            double resist = 1.0 - target.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).getAttributeValue();
            double f1 = resist * (double)(this.weaponDamage / 8.0f) * (double)0.6f;
            double k = f1 / (double)f;
            target.addVelocity(-dx * k, 0.15 * f1, -dz * k);
        }
        return true;
    }

    public int getItemEnchantability() {
        return 0;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.block;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (player.attackTime == 0) {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        }
        return stack;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int ticksRemaining) {
        if (this == ZSSItems.hammerSkull && player.attackTime == 0) {
            int ticksInUse = this.getMaxItemUseDuration(stack) - ticksRemaining;
            float charge = (float)ticksInUse / 40.0f;
            charge = Math.min((charge * charge + charge * 2.0f) / 3.0f, 1.0f);
            player.addExhaustion(charge * 2.0f);
            if (charge > 0.25f) {
                if (!player.worldObj.isRemote) {
                    PacketDispatcher.sendToAllAround(new PacketISpawnParticles(player, 4.0f), (Entity)player, 64.0);
                }
                player.swingItem();
                ZSSCombatEvents.setPlayerAttackTime(player);
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:leapingblow", 0.4f, 0.5f);
                DamageSource specialAttack = new DamageUtils.DamageSourceBaseDirect("player", (Entity)player).setStunDamage((int)(60.0f * charge), 5, true).setDamageBypassesArmor();
                float damage = this.weaponDamage * charge / 2.0f;
                if (damage > 0.5f) {
                    List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, player.boundingBox.expand(4.0, 0.0, 4.0));
                    for (EntityLivingBase entity : entities) {
                        if (entity == player || !entity.onGround) continue;
                        entity.attackEntityFrom(specialAttack, damage);
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, EntityPlayer player, ItemStack stack, double x, double y, double z, float radius) {
        int r = MathHelper.ceiling_float_int((float)radius);
        for (int i = 0; i < r; ++i) {
            for (int k = 0; k < r; ++k) {
                this.spawnParticlesAt(world, x + (double)i, y, z + (double)k);
                this.spawnParticlesAt(world, x + (double)i, y, z - (double)k);
                this.spawnParticlesAt(world, x - (double)i, y, z + (double)k);
                this.spawnParticlesAt(world, x - (double)i, y, z - (double)k);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticlesAt(World world, double x, double y, double z) {
        int posY = MathHelper.floor_double((double)y);
        Block block = world.getBlock(MathHelper.floor_double((double)x), posY - 1, MathHelper.floor_double((double)z));
        if (block.getMaterial() != Material.air) {
            String particle = "blockcrack_" + Block.getIdFromBlock((Block)block) + "_" + world.getBlockMetadata(MathHelper.floor_double((double)x), posY - 1, MathHelper.floor_double((double)z));
            for (int i = 0; i < 4; ++i) {
                double dx = x + (double)world.rand.nextFloat() - 0.5;
                double dy = (float)posY + world.rand.nextFloat() * 0.2f;
                double dz = z + (double)world.rand.nextFloat() - 0.5;
                world.spawnParticle(particle, dx, dy, dz, world.rand.nextGaussian(), 0.0, world.rand.nextGaussian());
            }
        }
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponDamage, 0));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc.0")));
    }

    @Override
    public boolean isSword(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isWeapon(ItemStack stack) {
        return !WeaponRegistry.INSTANCE.isWeaponForbidden(this);
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack main, ItemStack offhand) {
        return offhand == null;
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack stack) {
        return true;
    }
}

