/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.item.ItemMetadataBlock;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.OpenGossipStoneEditorPacket;

public class ItemGossipStone
extends ItemMetadataBlock {
    public ItemGossipStone(Block block) {
        super(block);
        this.setMaxStackSize(16);
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return StatCollector.translateToLocal((String)(this.getUnlocalizedName() + (stack.getItemDamage() > 0 ? ".name.unbreakable" : ".name")));
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote || side == 0) {
            return false;
        }
        if (!world.getBlock(x, y, z).getMaterial().isSolid()) {
            return false;
        }
        switch (side) {
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        Block block = ZSSBlocks.gossipStone;
        if (!player.canPlayerEdit(x, y, z, side, stack)) {
            return false;
        }
        if (!block.canPlaceBlockAt(world, x, y, z)) {
            return false;
        }
        if (!world.setBlock(x, y, z, block, stack.getItemDamage(), 3)) {
            return false;
        }
        block.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, stack);
        block.onPostBlockPlaced(world, x, y, z, stack.getItemDamage());
        if (!player.capabilities.isCreativeMode) {
            --stack.stackSize;
        }
        if (player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new OpenGossipStoneEditorPacket(x, y, z), (EntityPlayerMP)player);
        }
        return true;
    }
}

