/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.EntityFairy;
import zeldaswordskills.entity.EntityNavi;
import zeldaswordskills.util.WorldUtils;

public class ItemFairyBottle
extends Item
implements IUnenchantable {
    public ItemFairyBottle() {
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    public static boolean onDeath(EntityPlayer player) {
        for (int i = 0; i < InventoryPlayer.getHotbarSize(); ++i) {
            ItemStack stack = player.inventory.getStackInSlot(i);
            if (stack == null || !(stack.getItem() instanceof ItemFairyBottle) || stack.hasDisplayName()) continue;
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:fairy_laugh", 0.4f, 0.5f);
            player.setHealth(10.0f);
            player.inventory.setInventorySlotContents(i, new ItemStack(Items.glass_bottle));
            return true;
        }
        return false;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        boolean used = false;
        if (stack.hasDisplayName()) {
            if (player.isSneaking()) {
                used = true;
                if (!world.isRemote) {
                    Vec3 vec3 = player.getLookVec();
                    EntityNavi navi = new EntityNavi(world);
                    navi.setOwner(player);
                    navi.setCustomNameTag(stack.getDisplayName());
                    navi.setPosition(player.posX + vec3.xCoord * 2.0, player.posY + 1.6, player.posZ + vec3.zCoord * 2.0);
                    world.spawnEntityInWorld((Entity)navi);
                }
            }
        } else if (player.isSneaking()) {
            used = true;
            if (!world.isRemote) {
                Vec3 vec3 = player.getLookVec();
                EntityFairy fairy = new EntityFairy(world);
                fairy.setPosition(player.posX + vec3.xCoord * 2.0, player.posY + 1.6, player.posZ + vec3.zCoord * 2.0);
                List<TileEntityDungeonCore> list = WorldUtils.getTileEntitiesWithinAABB(world, TileEntityDungeonCore.class, fairy.boundingBox.expand(4.0, 3.0, 4.0));
                for (TileEntityDungeonCore core : list) {
                    if (!core.isSpawner()) continue;
                    fairy.setFairyHome(core.xCoord, core.yCoord + 1, core.zCoord);
                    break;
                }
                fairy.onReleased();
                world.spawnEntityInWorld((Entity)fairy);
            }
        } else if (player.getHealth() < player.getMaxHealth()) {
            used = true;
            if (!world.isRemote) {
                player.heal(player.getMaxHealth());
            }
        }
        if (used) {
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:cork", 0.4f, 1.0f);
            if (!player.capabilities.isCreativeMode || stack.hasDisplayName()) {
                --stack.stackSize;
                if (stack.stackSize <= 0) {
                    return new ItemStack(Items.glass_bottle);
                }
                player.inventory.addItemStackToInventory(new ItemStack(Items.glass_bottle));
            }
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        if (stack.hasDisplayName()) {
            list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocalFormatted((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".navi.desc.0"), (Object[])new Object[]{stack.getDisplayName()}));
        } else {
            for (int i = 0; i < 4; ++i) {
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc." + i)));
            }
        }
    }
}

