/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.ref.Config;

public class ItemDrinkable
extends Item {
    public ItemDrinkable(String name) {
        this.setUnlocalizedName("zss." + name);
        this.setTextureName("zeldaswordskills:" + name);
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 32;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.drink;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        return stack;
    }

    public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
        if (!player.capabilities.isCreativeMode) {
            if (stack == null || stack.stackSize <= 0) {
                return new ItemStack(Items.glass_bottle);
            }
            player.inventory.addItemStackToInventory(new ItemStack(Items.glass_bottle));
        }
        return stack;
    }

    public static class ItemPotionPurple
    extends ItemDrinkable {
        protected final int restore_hunger;
        protected final float saturation;

        public ItemPotionPurple(String name, int restore_hunger, float saturation) {
            super(name);
            this.restore_hunger = restore_hunger;
            this.saturation = saturation;
            this.setMaxStackSize(1);
            this.setCreativeTab(ZSSCreativeTabs.tabTools);
        }

        @Override
        public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
            if (!player.capabilities.isCreativeMode) {
                --stack.stackSize;
            }
            player.getFoodStats().addStats(this.restore_hunger, this.saturation);
            return super.onEaten(stack, world, player);
        }

        public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean hasEffect(ItemStack stack, int pass) {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
            list.add(EnumChatFormatting.GREEN + StatCollector.translateToLocalFormatted((String)"tooltip.zss.restore_stamina", (Object[])new Object[]{this.restore_hunger}));
        }
    }

    public static class ItemLonLonSpecial
    extends ItemDrinkable {
        public ItemLonLonSpecial(String name) {
            super(name);
            this.setMaxStackSize(1);
            this.setCreativeTab(ZSSCreativeTabs.tabTools);
        }

        @Override
        public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
            if (!player.capabilities.isCreativeMode) {
                --stack.stackSize;
            }
            ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
            info.setCurrentMagic(info.getMaxMagic());
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.UNLIMITED_MAGIC, 1200, 0);
            if (!Config.allowUnlimitedNayru()) {
                info.setFlag((byte)4, false);
            }
            return super.onEaten(stack, world, player);
        }

        public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
            list.add(StatCollector.translateToLocal((String)"tooltip.zss.lon_lon_special.desc.0"));
            list.add(StatCollector.translateToLocal((String)"tooltip.zss.lon_lon_special.desc.1"));
        }
    }
}

