/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.CustomEntityList;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.item.ItemCustomEgg;

public class ItemCustomVariantEgg
extends ItemCustomEgg {
    private final Class<? extends Entity> classToSpawn;
    private final String entityName;

    public ItemCustomVariantEgg(Class<? extends Entity> classToSpawn, String entityName) {
        this.classToSpawn = classToSpawn;
        this.entityName = entityName;
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        String s = ("" + StatCollector.translateToLocal((String)"item.zss.spawn_egg.name")).trim();
        if (this.entityName != null) {
            s = s + " " + StatCollector.translateToLocal((String)("entity.zeldaswordskills." + this.entityName + ".name." + stack.getItemDamage()));
        }
        return s;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        List<Integer> colors = CustomEntityList.entityEggs.get(this.classToSpawn);
        int colorIndex = stack.getItemDamage() * 2;
        return colors != null && colors.size() > colorIndex + 1 ? colors.get(renderPass == 0 ? colorIndex : colorIndex + 1) : 0xFFFFFF;
    }

    @Override
    public Entity spawnCreature(World world, int subtype, double x, double y, double z) {
        Entity entity = null;
        if (CustomEntityList.entityEggs.containsKey(this.classToSpawn) && (entity = CustomEntityList.createEntity(this.classToSpawn, world)) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            entity.setLocationAndAngles(x, y, z, MathHelper.wrapAngleTo180_float((float)(world.rand.nextFloat() * 360.0f)), 0.0f);
            entityliving.rotationYawHead = entityliving.rotationYaw;
            entityliving.renderYawOffset = entityliving.rotationYaw;
            entityliving.onSpawnWithEgg((IEntityLivingData)null);
            if (entity instanceof IEntityVariant) {
                ((IEntityVariant)entity).setType(subtype);
            }
            world.spawnEntityInWorld(entity);
            entityliving.playLivingSound();
        }
        return entity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List itemList) {
        List<Integer> colors = CustomEntityList.entityEggs.get(this.classToSpawn);
        if (colors == null || colors.isEmpty()) {
            ZSSMain.logger.error("Custom entity egg has an empty color list");
            return;
        }
        if (colors.size() % 2 != 0) {
            ZSSMain.logger.error("Custom entity egg has an odd number of colors");
        }
        for (int i = 0; i < colors.size() / 2; ++i) {
            itemList.add(new ItemStack(item, 1, i));
        }
    }
}

