/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.api.item.IRightClickEntity;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.CustomEntityList;

public class ItemCustomEgg
extends Item
implements IRightClickEntity,
IUnenchantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon overlay;

    public ItemCustomEgg() {
        this.setHasSubtypes(true);
        this.setTextureName("spawn_egg");
        this.setCreativeTab(ZSSCreativeTabs.tabEggs);
    }

    public String getItemStackDisplayName(ItemStack stack) {
        String s = ("" + StatCollector.translateToLocal((String)"item.zss.spawn_egg.name")).trim();
        String entityName = CustomEntityList.getStringFromID(stack.getItemDamage());
        if (entityName != null) {
            s = s + " " + StatCollector.translateToLocal((String)("entity.zeldaswordskills." + entityName + ".name"));
        }
        return s;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        List<Integer> colors = CustomEntityList.entityEggs.get(CustomEntityList.getClassFromID(stack.getItemDamage()));
        return colors != null && colors.size() > 1 ? colors.get(renderPass == 0 ? 0 : 1) : 0xFFFFFF;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Entity entity;
        if (world.isRemote) {
            return true;
        }
        Block block = world.getBlock(x, y, z);
        x += Facing.offsetsXForSide[side];
        y += Facing.offsetsYForSide[side];
        z += Facing.offsetsZForSide[side];
        double d0 = 0.0;
        if (side == 1 && block != null && block.getRenderType() == 11) {
            d0 = 0.5;
        }
        if ((entity = this.spawnCreature(world, stack.getItemDamage(), (double)x + 0.5, (double)y + d0, (double)z + 0.5)) != null) {
            if (entity instanceof EntityLiving && stack.hasDisplayName()) {
                ((EntityLiving)entity).setCustomNameTag(stack.getDisplayName());
            }
            if (!player.capabilities.isCreativeMode) {
                --stack.stackSize;
            }
        }
        return true;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition mop;
        if (!world.isRemote && (mop = this.getMovingObjectPositionFromPlayer(world, player, true)) != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            Entity entity;
            int i = mop.blockX;
            int j = mop.blockY;
            int k = mop.blockZ;
            if (!world.canMineBlock(player, i, j, k)) {
                return stack;
            }
            if (!player.canPlayerEdit(i, j, k, mop.sideHit, stack)) {
                return stack;
            }
            if (world.getBlock(i, j, k).getMaterial() == Material.water && (entity = this.spawnCreature(world, stack.getItemDamage(), i, j, k)) != null) {
                if (entity instanceof EntityLiving && stack.hasDisplayName()) {
                    ((EntityLiving)entity).setCustomNameTag(stack.getDisplayName());
                }
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                }
            }
        }
        return stack;
    }

    @Override
    public boolean onRightClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityAgeable) {
            return this.spawnChild(entity.worldObj, stack, player, (EntityAgeable)entity);
        }
        return false;
    }

    public Entity spawnCreature(World world, int entityID, double x, double y, double z) {
        Entity entity = null;
        Class<? extends Entity> oclass = CustomEntityList.getClassFromID(entityID);
        if (CustomEntityList.entityEggs.containsKey(oclass) && (entity = CustomEntityList.createEntity(oclass, world)) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            entity.setLocationAndAngles(x, y, z, MathHelper.wrapAngleTo180_float((float)(world.rand.nextFloat() * 360.0f)), 0.0f);
            entityliving.rotationYawHead = entityliving.rotationYaw;
            entityliving.renderYawOffset = entityliving.rotationYaw;
            entityliving.onSpawnWithEgg((IEntityLivingData)null);
            world.spawnEntityInWorld(entity);
            entityliving.playLivingSound();
        }
        return entity;
    }

    private boolean spawnChild(World world, ItemStack stack, EntityPlayer player, EntityAgeable entity) {
        EntityAgeable child;
        Class<? extends Entity> oclass = CustomEntityList.getClassFromID(stack.getItemDamage());
        if (oclass != null && oclass == entity.getClass() && (child = entity.createChild(entity)) != null) {
            child.setGrowingAge(-24000);
            child.setLocationAndAngles(entity.posX, entity.posY, entity.posZ, 0.0f, 0.0f);
            if (!world.isRemote) {
                world.spawnEntityInWorld((Entity)child);
            }
            if (stack.hasDisplayName()) {
                child.setCustomNameTag(stack.getDisplayName());
            }
            if (!player.capabilities.isCreativeMode) {
                --stack.stackSize;
                if (stack.stackSize <= 0) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List itemList) {
        for (Class<? extends Entity> oclass : CustomEntityList.entityEggs.keySet()) {
            List<Integer> colors = CustomEntityList.entityEggs.get(oclass);
            if (colors == null || colors.size() != 2) continue;
            itemList.add(new ItemStack(item, 1, CustomEntityList.getEntityId(oclass)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int damage, int pass) {
        return pass > 0 ? this.overlay : super.getIconFromDamageForRenderPass(damage, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        super.registerIcons(register);
        this.overlay = register.registerIcon(this.getIconString() + "_overlay");
    }
}

