/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSVillagerInfo;
import zeldaswordskills.entity.mobs.EntityChu;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemChuJelly
extends Item
implements IUnenchantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    private static final Map<EntityChu.ChuType, Item> jellyMap = new EnumMap<EntityChu.ChuType, Item>(EntityChu.ChuType.class);

    public ItemChuJelly() {
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabMisc);
    }

    private EntityChu.ChuType getType(ItemStack stack) {
        return EntityChu.ChuType.values()[stack.getItemDamage() % EntityChu.ChuType.values().length];
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.worldObj.isRemote && entity.getClass() == EntityVillager.class) {
            EntityVillager entityVillager = (EntityVillager)entity;
            ZSSVillagerInfo villager = ZSSVillagerInfo.get(entityVillager);
            MerchantRecipeList trades = entityVillager.getRecipes(player);
            EntityChu.ChuType type = this.getType(stack);
            entityVillager.playLivingSound();
            if (villager != null && villager.isChuTrader() && jellyMap.containsKey((Object)type)) {
                if (villager.getJelliesReceived(type) == 0) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.jelly.first", new Object[0]);
                    villager.addJelly(type, 1);
                    --stack.stackSize;
                } else if (villager.canSellType(type, stack)) {
                    MerchantRecipe trade = new MerchantRecipe(new ItemStack(stack.getItem(), 4, type.ordinal()), new ItemStack(Items.emerald, (type.ordinal() + 1) * 8), new ItemStack(jellyMap.get((Object)type)));
                    if (MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                        player.worldObj.playSoundAtEntity((Entity)player, "zeldaswordskills:success", 1.0f, 1.0f);
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.jelly.new_stock", new Object[0]);
                        PlayerUtils.addItemToInventory(player, new ItemStack(jellyMap.get((Object)type)));
                    } else {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.jelly.in_stock", new Object[0]);
                    }
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.jelly.need_more", new Object[0]);
                }
                if (stack.stackSize == 0) {
                    player.setCurrentItemOrArmor(0, null);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.jelly.gross", new Object[0]);
            }
        }
        return true;
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.getUnlocalizedName() + "." + stack.getItemDamage();
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < EntityChu.ChuType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        return this.iconArray[damage % EntityChu.ChuType.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.iconArray = new IIcon[EntityChu.ChuType.values().length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.jelly_chu.desc.0"));
    }

    public static void initializeJellies() {
        jellyMap.put(EntityChu.ChuType.RED, ZSSItems.potionRed);
        jellyMap.put(EntityChu.ChuType.GREEN, ZSSItems.potionGreen);
        jellyMap.put(EntityChu.ChuType.BLUE, ZSSItems.potionBlue);
        jellyMap.put(EntityChu.ChuType.YELLOW, ZSSItems.potionYellow);
    }
}

