/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.api.gen.ISeedStructure;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.util.PlayerUtils;

public class ItemBuilderSeed
extends Item {
    private final Class<? extends ISeedStructure> structure;
    private String failMessage;

    public ItemBuilderSeed(Class<? extends ISeedStructure> structure, String failMessage, String texture) {
        this.structure = structure;
        this.failMessage = failMessage;
        this.setTextureName("zeldaswordskills:" + texture);
        this.setCreativeTab(ZSSCreativeTabs.tabMisc);
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            ISeedStructure seed = ItemBuilderSeed.getSeedStructure(this.structure);
            if (seed != null) {
                if (seed.generate(world, player, x, y, z, side)) {
                    if (!player.capabilities.isCreativeMode) {
                        --stack.stackSize;
                    }
                    return true;
                }
                if (this.failMessage != null && this.failMessage.length() > 0) {
                    PlayerUtils.sendTranslatedChat(player, this.failMessage, new Object[0]);
                }
            }
            return false;
        }
        return true;
    }

    public static final ISeedStructure getSeedStructure(Class<? extends ISeedStructure> structure) {
        ISeedStructure seed = null;
        try {
            seed = structure.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return seed;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc.0")));
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc.1")));
    }
}

