/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntityBoomerang;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ItemBoomerang
extends Item
implements IFairyUpgrade,
IUnenchantable {
    private final float damage;
    private final int range;
    private boolean captureAll;

    public ItemBoomerang(float damage, int range) {
        this.damage = damage;
        this.range = range;
        this.captureAll = false;
        this.setFull3D();
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabCombat);
    }

    public ItemBoomerang setCaptureAll() {
        this.captureAll = true;
        return this;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.swingItem();
        player.addExhaustion(0.3f);
        if (!world.isRemote) {
            world.playSoundAtEntity((Entity)player, "zeldaswordskills:whoosh", 1.0f, 1.0f);
            world.spawnEntityInWorld((Entity)new EntityBoomerang(world, (EntityLivingBase)player).setCaptureAll(this.captureAll).setRange(this.range).setInvStack(stack, player.inventory.currentItem).setDamage(this.damage));
            player.setCurrentItemOrArmor(0, null);
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.boomerang.desc.0"));
        list.add("");
        list.add(EnumChatFormatting.BLUE + StatCollector.translateToLocalFormatted((String)"tooltip.zss.damage", (Object[])new Object[]{"+", (int)this.damage}));
        list.add(EnumChatFormatting.YELLOW + StatCollector.translateToLocalFormatted((String)"tooltip.zss.range", (Object[])new Object[]{this.range}));
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        if (ZSSPlayerSkills.get(player).getSkillLevel(SkillBase.bonusHeart) >= Config.getMaxBonusHearts() / 2) {
            item.setDead();
            player.triggerAchievement((StatBase)ZSSAchievements.fairyBoomerang);
            WorldUtils.spawnItemWithRandom(core.getWorldObj(), new ItemStack(ZSSItems.boomerangMagic), core.xCoord, core.yCoord + 2, core.zCoord);
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else {
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.fairy.laugh.unworthy", new Object[0]);
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return this == ZSSItems.boomerang;
    }
}

