/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.item.IRightClickEntity;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.util.PlayerUtils;

public class ItemBombFlowerSeed
extends ItemSeeds
implements IRightClickEntity {
    public ItemBombFlowerSeed() {
        super(ZSSBlocks.bombFlower, Blocks.stone);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block plant;
        if (side != 1 || !player.canPlayerEdit(x, y, z, side, stack) || !player.canPlayerEdit(x, y + 1, z, side, stack)) {
            return false;
        }
        if ((plant = this.getPlant((IBlockAccess)world, x, ++y, z)).canPlaceBlockAt(world, x, y, z)) {
            if (!world.isRemote) {
                world.setBlock(x, y, z, plant);
            }
            --stack.stackSize;
            return true;
        }
        return false;
    }

    @Override
    public boolean onRightClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityChicken) {
            if (!player.worldObj.isRemote && PlayerUtils.consumeHeldItem(player, (Item)this, 1)) {
                ((EntityChicken)entity).func_146082_f(player);
                int time = 60 + entity.worldObj.rand.nextInt(60);
                EntityBomb bomb = new EntityBomb(entity.worldObj).setType(BombType.BOMB_STANDARD).setFuseTime(time);
                ZSSEntityInfo.get((EntityLivingBase)((EntityChicken)entity)).onBombIngested(bomb);
            }
            return true;
        }
        return false;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity entity, ItemStack stack) {
        EntityItem item = new EntityItem(world, entity.posX, entity.posY, entity.posZ, stack){

            public void onUpdate() {
                super.onUpdate();
                if (!this.worldObj.isRemote && this.ticksExisted > 80 && this.worldObj.rand.nextInt(128) == 0) {
                    int i = MathHelper.floor_double((double)this.posX);
                    int j = MathHelper.floor_double((double)this.posY);
                    int k = MathHelper.floor_double((double)this.posZ);
                    boolean flag = false;
                    if (ZSSBlocks.bombFlower.canPlaceBlockAt(this.worldObj, i, j, k)) {
                        flag = true;
                    } else if (ZSSBlocks.bombFlower.canPlaceBlockAt(this.worldObj, i + 1, j, k)) {
                        ++i;
                        flag = true;
                    } else if (ZSSBlocks.bombFlower.canPlaceBlockAt(this.worldObj, i - 1, j, k)) {
                        --i;
                        flag = true;
                    } else if (ZSSBlocks.bombFlower.canPlaceBlockAt(this.worldObj, i, j, k + 1)) {
                        ++k;
                        flag = true;
                    } else if (ZSSBlocks.bombFlower.canPlaceBlockAt(this.worldObj, i, j, k - 1)) {
                        --k;
                        flag = true;
                    }
                    if (flag) {
                        this.worldObj.setBlock(i, j, k, ZSSBlocks.bombFlower);
                        --this.getEntityItem().stackSize;
                        if (this.getEntityItem().stackSize == 0) {
                            this.setDead();
                        }
                    }
                }
            }
        };
        item.motionX = entity.motionX;
        item.motionY = entity.motionY;
        item.motionZ = entity.motionZ;
        item.delayBeforeCanPickup = 40;
        return item;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Cave;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }
}

