/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ItemBombBag
extends Item
implements IUnenchantable {
    private static final int BASE_CAPACITY = 10;
    private static final int MAX_CAPACITY = 50;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] ones;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] tens;

    public ItemBombBag() {
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (player.capabilities.isCreativeMode || this.removeBomb(stack)) {
            int type;
            if (!player.inventory.addItemStackToInventory(stack)) {
                player.dropPlayerItemWithRandomChoice(stack, false);
            }
            return new ItemStack(ZSSItems.bomb, 1, (type = this.getBagBombType(stack)) > 0 ? type : 0);
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityBomb) {
            return ((EntityBomb)entity).disarm(entity.worldObj);
        }
        if (entity instanceof EntityVillager && !player.worldObj.isRemote) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.getRecipes(player);
            if (villager.getProfession() != 1 && trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.copy(), new ItemStack(Items.emerald, 16));
                if (player.worldObj.rand.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.1", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
        return true;
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (!world.isRemote && isHeld && this.getBombsHeld(stack) < this.getCapacity(stack) && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
                ItemStack invStack = player.inventory.getStackInSlot(i);
                if (invStack == null || !this.areMatchingTypes(stack, invStack, true) || this.addBombs(stack, invStack) >= 1) continue;
                player.inventory.setInventorySlotContents(i, null);
                if (this.getBombsHeld(stack) != this.getCapacity(stack)) continue;
                return;
            }
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        int bombsHeld = this.getBombsHeld(stack);
        switch (pass) {
            case 0: {
                return this.itemIcon;
            }
            case 1: {
                return this.ones[bombsHeld % 10];
            }
            case 2: {
                return this.tens[bombsHeld / 10 % 10];
            }
        }
        return this.itemIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
        this.ones = new IIcon[10];
        this.tens = new IIcon[10];
        for (int i = 0; i < 10; ++i) {
            this.ones[i] = register.registerIcon("zeldaswordskills:digits/" + (i == 0 ? "" : "00") + i);
            this.tens[i] = register.registerIcon("zeldaswordskills:digits/0" + i + (i == 0 ? "" : "0"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.bombbag.desc.0"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.bombbag.desc.1"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.bombbag.desc.2"));
        int held = this.getBombsHeld(stack);
        int i = this.getBagBombType(stack);
        BombType type = held > 0 && i > 0 ? BombType.values()[i % BombType.values().length] : BombType.BOMB_STANDARD;
        String bombName = StatCollector.translateToLocal((String)("item.zss.bomb." + type.unlocalizedName + ".name"));
        list.add(EnumChatFormatting.BOLD + StatCollector.translateToLocalFormatted((String)"tooltip.zss.bombbag.desc.bombs", (Object[])new Object[]{bombName, held, this.getCapacity(stack)}));
    }

    public int addBombs(ItemStack stack, int amount) {
        int bombs = this.getBombsHeld(stack) + amount;
        if (amount < 0) {
            stack.getTagCompound().setInteger("bombs", Math.max(0, bombs));
            if (bombs < 1) {
                this.setBagBombType(stack, -1);
            }
            return -Math.min(0, bombs);
        }
        int capacity = this.getCapacity(stack);
        stack.getTagCompound().setInteger("bombs", Math.min(bombs, capacity));
        return -Math.min(0, capacity - bombs);
    }

    public int addBombs(ItemStack bag, ItemStack bombs) {
        if (ItemBomb.getType(bombs) == BombType.BOMB_FLOWER) {
            return bombs.stackSize;
        }
        if (this.areMatchingTypes(bag, bombs, true)) {
            int remaining = this.addBombs(bag, bombs.stackSize);
            this.setBagBombType(bag, ItemBomb.getType(bombs).ordinal());
            return remaining;
        }
        return bombs.stackSize;
    }

    public boolean removeBomb(ItemStack stack) {
        if (this.getBombsHeld(stack) > 0) {
            this.addBombs(stack, -1);
            return true;
        }
        return false;
    }

    public void emptyBag(ItemStack stack, EntityPlayer player) {
        int n = this.getBombsHeld(stack);
        int type = this.getBagBombType(stack);
        if (type < 0 || n < 1) {
            return;
        }
        ItemStack newBag = new ItemStack(ZSSItems.bombBag);
        this.setCapacity(newBag, this.getCapacity(stack));
        if (player.inventory.addItemStackToInventory(newBag)) {
            player.setCurrentItemOrArmor(0, null);
            while (n-- > 0) {
                ItemStack bomb = new ItemStack(ZSSItems.bomb, 1, type);
                if (player.inventory.addItemStackToInventory(bomb)) continue;
                WorldUtils.spawnItemWithRandom(player.worldObj, bomb, player.posX, player.posY, player.posZ);
            }
        }
    }

    public int getCapacity(ItemStack stack) {
        return this.getCapacity(stack, false);
    }

    public int getCapacity(ItemStack stack, boolean trueCapacity) {
        int capacity = stack.hasTagCompound() ? Math.max(10, stack.getTagCompound().getInteger("capacity")) : 10;
        int type = this.getBagBombType(stack);
        return trueCapacity || type == -1 || type == BombType.BOMB_STANDARD.ordinal() ? capacity : capacity / 2;
    }

    public void setCapacity(ItemStack stack, int size) {
        this.verifyNBT(stack);
        stack.getTagCompound().setInteger("capacity", Math.min(size, 50));
    }

    public int getBombsHeld(ItemStack stack) {
        int bombsHeld;
        this.verifyNBT(stack);
        int n = bombsHeld = stack.hasTagCompound() ? stack.getTagCompound().getInteger("bombs") : 0;
        if (bombsHeld < 0) {
            stack.getTagCompound().setInteger("bombs", 0);
        }
        return bombsHeld < 0 ? 0 : bombsHeld;
    }

    public int getBagBombType(ItemStack stack) {
        return stack.hasTagCompound() ? stack.getTagCompound().getInteger("type") : -1;
    }

    public void setBagBombType(ItemStack bag, int type) {
        this.verifyNBT(bag);
        bag.getTagCompound().setInteger("type", type);
    }

    public boolean areMatchingTypes(ItemStack bag, ItemStack stack, boolean isBomb) {
        int type = this.getBagBombType(bag);
        if (isBomb && stack.getItem() instanceof ItemBomb) {
            return this.getBombsHeld(bag) == 0 || type == -1 || type == ItemBomb.getType(stack).ordinal();
        }
        if (!isBomb && stack.getItem() instanceof ItemBombBag) {
            int type2 = this.getBagBombType(stack);
            return this.getBombsHeld(bag) == 0 || type == -1 || this.getBombsHeld(stack) == 0 || type == type2 || type2 == -1;
        }
        return false;
    }

    public boolean canCombine(ItemStack bag, ItemStack stack) {
        if (stack == null || stack == bag || !this.areMatchingTypes(bag, stack, false)) {
            return false;
        }
        return this.getCapacity(bag, true) + this.getCapacity(stack, true) <= 50;
    }

    private void verifyNBT(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
            stack.getTagCompound().setInteger("bombs", 0);
            stack.getTagCompound().setInteger("type", -1);
            stack.getTagCompound().setInteger("capacity", 10);
        }
    }
}

