/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.item.IHandlePickup;
import zeldaswordskills.api.item.IHandleToss;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.npc.EntityNpcBarnes;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.server.BombTickPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;

public class ItemBomb
extends Item
implements IHandlePickup,
IHandleToss,
IUnenchantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    public static final float RADIUS = 3.0f;

    public ItemBomb() {
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
        this.setFull3D();
    }

    public static BombType getType(ItemStack stack) {
        return ItemBomb.getType(stack.getItemDamage());
    }

    public static BombType getType(int damage) {
        return damage < BombType.values().length ? BombType.values()[damage] : BombType.BOMB_STANDARD;
    }

    public static float getRadius(BombType type) {
        return type == BombType.BOMB_WATER ? 2.25f : 3.0f;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (!world.isRemote) {
            int fuseTime = Config.getBombFuseTime() > 0 ? Config.getBombFuseTime() : 56;
            world.spawnEntityInWorld((Entity)new EntityBomb(world, (EntityLivingBase)player).setType(ItemBomb.getType(stack)).addTime(fuseTime -= stack.hasTagCompound() ? stack.getTagCompound().getInteger("time") : 0));
        }
        player.destroyCurrentEquippedItem();
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityNpcBarnes) {
            if (!player.worldObj.isRemote) {
                if (((EntityNpcBarnes)entity).addBombBagTrade()) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.bomb.add", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.bomb.careful", new Object[0]);
                }
            }
            return true;
        }
        if (entity instanceof INpc) {
            if (!player.worldObj.isRemote) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.bomb.careful", new Object[0]);
            }
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @Override
    public boolean onPickupItem(ItemStack stack, EntityPlayer player) {
        for (ItemStack invStack : player.inventory.mainInventory) {
            if (invStack == null || !(invStack.getItem() instanceof ItemBombBag)) continue;
            stack.stackSize -= stack.stackSize - ((ItemBombBag)invStack.getItem()).addBombs(invStack, stack);
            if (stack.stackSize < 1) break;
        }
        return true;
    }

    @Override
    public void onItemTossed(EntityItem item, EntityPlayer player) {
        ItemStack stack = item.getEntityItem();
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("time")) {
            stack.getTagCompound().setInteger("time", 0);
        }
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
            stack.getTagCompound().setInteger("time", 0);
            stack.getTagCompound().setBoolean("inWater", false);
        }
        if (isHeld || ItemBomb.getType(stack) == BombType.BOMB_FLOWER) {
            if (entity instanceof EntityPlayer) {
                if (world.isRemote && Minecraft.getMinecraft().currentScreen == null) {
                    PacketDispatcher.sendToServer(new BombTickPacket(slot));
                }
            } else {
                this.tickBomb(stack, world, entity, slot);
            }
        } else {
            stack.getTagCompound().setInteger("time", 0);
            stack.getTagCompound().setBoolean("inWater", false);
        }
    }

    public void tickBomb(ItemStack stack, World world, Entity entity, int slot) {
        BombType type;
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
            stack.getTagCompound().setInteger("time", 0);
            stack.getTagCompound().setBoolean("inWater", false);
        }
        if ((type = ItemBomb.getType(stack)) != BombType.BOMB_WATER && world.getBlock((int)entity.posX, (int)entity.posY + 1, (int)entity.posZ).getMaterial() == Material.water) {
            stack.getTagCompound().setInteger("time", 0);
            stack.getTagCompound().setBoolean("inWater", true);
        } else if (stack.getTagCompound().getBoolean("inWater")) {
            stack.getTagCompound().setBoolean("inWater", false);
        }
        if (this.canTick(world, type, stack.getTagCompound().getBoolean("inWater"))) {
            int time = stack.getTagCompound().getInteger("time");
            if (time % 20 == 0) {
                world.playSoundAtEntity(entity, "zeldaswordskills:bomb_fuse", 1.0f, 2.0f + entity.worldObj.rand.nextFloat() * 0.4f);
            }
            boolean flag = world.provider.isHellWorld && (type == BombType.BOMB_STANDARD || type == BombType.BOMB_FLOWER);
            stack.getTagCompound().setInteger("time", flag ? Config.getBombFuseTime() : ++time);
            int fuse = Config.getBombFuseTime();
            if (fuse == 0 && type == BombType.BOMB_FLOWER) {
                fuse = 56;
            }
            if (time == fuse && !world.isRemote) {
                EntityBomb bomb = null;
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).inventory.setInventorySlotContents(slot, null);
                    bomb = new EntityBomb(world, (EntityLivingBase)((EntityPlayer)entity)).setType(type);
                } else {
                    entity.setCurrentItemOrArmor(slot, null);
                    bomb = new EntityBomb(world).setType(type);
                }
                CustomExplosion.createExplosion(bomb, world, entity.posX, entity.posY, entity.posZ, ItemBomb.getRadius(type), 0.0f, true);
            }
        }
    }

    private boolean canTick(World world, BombType type, boolean inWater) {
        if (Config.getBombFuseTime() > 0) {
            switch (type) {
                case BOMB_WATER: {
                    return world.provider.dimensionId != -1;
                }
            }
            return !inWater;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int type) {
        return this.iconArray[ItemBomb.getType(type).ordinal()];
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.getUnlocalizedName() + "." + ItemBomb.getType((ItemStack)stack).unlocalizedName;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < BombType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.iconArray = new IIcon[BombType.values().length];
        String s = "zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_";
        for (int i = 0; i < BombType.values().length; ++i) {
            this.iconArray[i] = register.registerIcon(s + ItemBomb.getType((int)i).unlocalizedName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.bomb.desc.0"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.bomb.desc.1"));
    }
}

