/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.world.World;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.npc.EntityGoron;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemArmorTunic
extends ItemArmor {
    protected PotionEffect tickingEffect = null;

    public ItemArmorTunic(int renderIndex, int type) {
        super(ItemArmor.ArmorMaterial.CHAIN, renderIndex, type);
        this.setCreativeTab(ZSSCreativeTabs.tabCombat);
    }

    public ItemArmorTunic setEffect(PotionEffect effect) {
        this.tickingEffect = effect;
        return this;
    }

    public PotionEffect getEffect() {
        return this.tickingEffect;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.worldObj.isRemote && this == ZSSItems.tunicGoronChest && entity instanceof EntityGoron) {
            if (stack.getItemDamage() > 0) {
                MerchantRecipe trade = new MerchantRecipe(new ItemStack(ZSSItems.tunicGoronChest), new ItemStack(Items.emerald, 8), new ItemStack(ZSSItems.tunicGoronChest));
                MerchantRecipeHelper.addToListWithCheck(((EntityVillager)entity).getRecipes(player), trade);
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.goron.tunic.repair", new Object[0]);
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.goron.tunic.undamaged", new Object[0]);
            }
        }
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        PotionEffect effect = this.getEffect();
        if (effect != null && this.shouldDamageArmor(world, player, stack, effect.getPotionID())) {
            player.addPotionEffect(new PotionEffect(effect));
            player.setAir(300);
            this.damageStack(stack, (EntityLivingBase)player, 1);
        }
    }

    public static boolean onFireDamage(EntityLivingBase entity, float damage) {
        ItemStack stack = entity.getEquipmentInSlot(3);
        if (!entity.worldObj.isRemote && stack != null && stack.getItem() == ZSSItems.tunicGoronChest) {
            if (entity.isPotionActive(Potion.fireResistance.getId())) {
                return true;
            }
            damage *= 1.0f + (float)ZSSEntityInfo.get(entity).getBuffAmplifier(Buff.WEAKNESS_FIRE) * 0.01f;
            if ((damage *= 1.0f - (float)ZSSEntityInfo.get(entity).getBuffAmplifier(Buff.RESIST_FIRE) * 0.01f) < 0.1f) {
                entity.extinguish();
                return true;
            }
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            if (!stack.getTagCompound().hasKey("lastDamaged") || entity.worldObj.getTotalWorldTime() > stack.getTagCompound().getLong("lastDamaged") + 20L) {
                stack.getTagCompound().setLong("lastDamaged", entity.worldObj.getTotalWorldTime());
                ((ItemArmorTunic)stack.getItem()).damageStack(stack, entity, Math.max((int)damage / 4, 1));
                entity.extinguish();
            }
            return true;
        }
        return false;
    }

    private void damageStack(ItemStack stack, EntityLivingBase entity, int amount) {
        stack.damageItem(amount, entity);
        if (stack.stackSize == 0 || stack.getItemDamage() >= stack.getMaxDamage()) {
            entity.worldObj.playSoundAtEntity((Entity)entity, "random.break", 1.0f, 1.0f);
            entity.setCurrentItemOrArmor(EntityLiving.getArmorPosition((ItemStack)stack), null);
        }
    }

    private boolean shouldDamageArmor(World world, EntityPlayer player, ItemStack stack, int effectID) {
        Material m = world.getBlock((int)player.posX, (int)player.posY + 1, (int)player.posZ).getMaterial();
        if (effectID == Potion.waterBreathing.id) {
            if (player.isPotionActive(Potion.waterBreathing.getId())) {
                return false;
            }
            ItemStack helm = player.getCurrentArmor(3);
            if (helm != null && helm.getItem() == ZSSItems.maskZora) {
                return false;
            }
            int time = 50 + 50 * EnchantmentHelper.getRespiration((EntityLivingBase)player) + (helm != null && helm.getItem() == ZSSItems.tunicZoraHelm ? 100 : 0);
            return m == Material.water && world.getTotalWorldTime() % (long)time == 0L;
        }
        return false;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        String name = this.getUnlocalizedName().substring(9, this.getUnlocalizedName().lastIndexOf("_"));
        return String.format("%s:textures/armor/%s_layer_%d.png", "zeldaswordskills", name, slot == 2 ? 2 : 1);
    }

    public int getItemEnchantability() {
        return ItemArmor.ArmorMaterial.CLOTH.getEnchantability();
    }

    public boolean getIsRepairable(ItemStack toRepair, ItemStack stack) {
        if (this == ZSSItems.tunicGoronChest) {
            return stack.getItem() == Items.magma_cream;
        }
        if (this == ZSSItems.tunicZoraChest) {
            // empty if block
        }
        return stack.getItem() == Item.getItemFromBlock((Block)Blocks.wool);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        String[] tooltips;
        for (String tooltip : tooltips = StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc")).split("\\\\n")) {
            list.add(EnumChatFormatting.ITALIC + tooltip);
        }
    }
}

