/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import zeldaswordskills.entity.npc.EntityNpcMaskTrader;
import zeldaswordskills.inventory.InventoryMaskTrader;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.server.BorrowMaskPacket;

public class ContainerMaskTrader
extends Container {
    private final InventoryMaskTrader inv;
    private boolean maskBorrowed = false;
    private final EntityNpcMaskTrader salesman;

    public ContainerMaskTrader(EntityNpcMaskTrader salesman) {
        this.salesman = salesman;
        this.inv = new InventoryMaskTrader();
        for (int i = 0; i < this.inv.getSizeInventory(); ++i) {
            this.addSlotToContainer(new Slot((IInventory)this.inv, i, (i > 5 ? 116 : 8) + i % 3 * 18, i % 6 > 2 ? 142 : 124));
        }
        this.addSlotToContainer(new Slot((IInventory)new InventoryBasic("", true, 1), 0, 80, 124));
    }

    public boolean canBorrow() {
        return ((Slot)this.inventorySlots.get(this.inv.getSizeInventory())).getHasStack();
    }

    public void borrowMask() {
        ItemStack mask = ((Slot)this.inventorySlots.get(this.inv.getSizeInventory())).getStack();
        PacketDispatcher.sendToServer(new BorrowMaskPacket(mask));
        this.maskBorrowed = true;
    }

    public boolean canInteractWith(EntityPlayer player) {
        return !this.maskBorrowed && this.inv.isUseableByPlayer(player);
    }

    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        this.salesman.setCustomer(null);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int index) {
        return null;
    }

    public ItemStack slotClick(int slotIndex, int button, int par3, EntityPlayer player) {
        Slot slot;
        if (slotIndex >= 0 && slotIndex < this.inv.getSizeInventory() && (slot = (Slot)this.inventorySlots.get(slotIndex)) != null && slot.getHasStack()) {
            ((Slot)this.inventorySlots.get((int)this.inv.getSizeInventory())).inventory.setInventorySlotContents(0, slot.getStack().copy());
        }
        return null;
    }
}

