/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.handler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.ILiftable;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.IHandlePickup;
import zeldaswordskills.api.item.IHandleToss;
import zeldaswordskills.api.item.ILiftBlock;
import zeldaswordskills.api.item.ISmashBlock;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.entity.mobs.EntityDarknut;
import zeldaswordskills.entity.mobs.EntityKeese;
import zeldaswordskills.entity.mobs.EntityOctorok;
import zeldaswordskills.entity.mobs.EntityWizzrobe;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.handler.ZSSCombatEvents;
import zeldaswordskills.item.ItemHeldBlock;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.UnpressKeyPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ZSSItemEvents {
    private static final Map<Class<? extends EntityLivingBase>, ItemStack> dropsList = new HashMap<Class<? extends EntityLivingBase>, ItemStack>();

    public ZSSItemEvents() {
        if (dropsList.isEmpty()) {
            ZSSItemEvents.init();
        }
    }

    private static void addDrop(Class<? extends EntityLivingBase> mobClass, SkillBase skill) {
        ItemStack stack = new ItemStack(ZSSItems.skillOrb, 1, (int)skill.getId());
        dropsList.put(mobClass, stack);
    }

    private static ItemStack getOrbDrop(EntityLivingBase mob, boolean isBoss) {
        if (dropsList.get(mob.getClass()) != null && mob.worldObj.rand.nextFloat() > Config.getChanceForRandomDrop()) {
            return dropsList.get(mob.getClass());
        }
        ItemStack orb = null;
        int id = mob.worldObj.rand.nextInt(SkillBase.getNumSkills());
        if (SkillBase.doesSkillExist(id) && SkillBase.getSkill(id).canDrop() && (dropsList.get(mob.getClass()) != null || isBoss || mob.worldObj.rand.nextFloat() < Config.getRandomMobDropChance())) {
            orb = id == SkillBase.bonusHeart.getId() ? new ItemStack(ZSSItems.heartPiece) : new ItemStack(ZSSItems.skillOrb, 1, id);
        }
        return orb;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (event.source.getEntity() instanceof EntityPlayer) {
            ItemStack orb;
            EntityPlayer player = (EntityPlayer)event.source.getEntity();
            EntityLivingBase mob = event.entityLiving;
            boolean isBoss = mob instanceof IBossDisplayData;
            boolean flag = ZSSPlayerSkills.get(player).getSkillLevel(SkillBase.mortalDraw) == SkillBase.mortalDraw.getMaxLevel();
            ItemStack itemStack = orb = isBoss && !flag ? new ItemStack(ZSSItems.skillOrb, 1, (int)SkillBase.mortalDraw.getId()) : ZSSItemEvents.getOrbDrop(mob, isBoss);
            if (orb != null && Config.areOrbDropsEnabled()) {
                ItemStack helm = player.getCurrentArmor(3);
                float f = helm != null && helm.getItem() == ZSSItems.maskTruth ? 0.01f : 0.0f;
                float baseChance = Config.getDropChance(orb.getItem() == ZSSItems.heartPiece ? SkillBase.bonusHeart.getId() : orb.getItemDamage());
                if (baseChance > 0.0f && (isBoss || mob.worldObj.rand.nextFloat() < baseChance + f + 0.005f * (float)event.lootingLevel)) {
                    event.drops.add(new EntityItem(mob.worldObj, mob.posX, mob.posY, mob.posZ, orb.copy()));
                    mob.worldObj.playSoundEffect(mob.posX, mob.posY, mob.posZ, "zeldaswordskills:special_drop", 1.0f, 1.0f);
                    player.triggerAchievement((StatBase)ZSSAchievements.skillGain);
                    if (isBoss) {
                        player.triggerAchievement((StatBase)ZSSAchievements.skillMortal);
                    }
                }
            }
            if (mob instanceof EntityCreeper && mob.worldObj.rand.nextFloat() < Config.getCreeperDropChance()) {
                event.drops.add(new EntityItem(mob.worldObj, mob.posX, mob.posY, mob.posZ, new ItemStack(ZSSItems.bomb)));
            }
            if (mob instanceof IMob && mob.worldObj.rand.nextInt(Config.getPowerDropRate()) == 0) {
                event.drops.add(new EntityItem(mob.worldObj, mob.posX, mob.posY, mob.posZ, new ItemStack(ZSSItems.powerPiece)));
            }
            if (mob instanceof IMob) {
                int consumable_chance;
                float hp = mob.getMaxHealth();
                float chance = MathHelper.clamp_float((float)((hp - 40.0f) / 100.0f), (float)0.0f, (float)0.25f);
                if (hp > 100.0f) {
                    chance = MathHelper.clamp_float((float)(chance + (hp - 100.0f) / 2000.0f), (float)0.0f, (float)0.5f);
                }
                if (mob.worldObj.rand.nextFloat() < chance) {
                    event.drops.add(new EntityItem(mob.worldObj, mob.posX, mob.posY, mob.posZ, new ItemStack(ZSSItems.magicJarBig)));
                }
                if ((consumable_chance = Config.getMobConsumableFrequency()) > 0 && mob.worldObj.rand.nextInt((event.drops.size() + 1) * (12 - consumable_chance)) == 0) {
                    ItemStack stack = new ItemStack(mob.worldObj.rand.nextInt(4) == 0 ? ZSSItems.magicJar : ZSSItems.smallHeart);
                    event.drops.add(new EntityItem(mob.worldObj, mob.posX, mob.posY, mob.posZ, stack));
                }
            }
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean left = event.left.getItem() instanceof ItemEnchantedBook && event.right.getItem().getItemEnchantability() < 1 && (Config.areUnenchantablesDisabled() || event.right.getItem() instanceof IUnenchantable);
        boolean right = event.right.getItem() instanceof ItemEnchantedBook && event.left.getItem().getItemEnchantability() < 1 && (Config.areUnenchantablesDisabled() || event.left.getItem() instanceof IUnenchantable);
        event.setCanceled(left || right);
    }

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester != null) {
            if (event.block == Blocks.dirt || event.block == Blocks.grass) {
                if (event.harvester.getCurrentArmor(3) != null && event.harvester.getCurrentArmor(3).getItem() == ZSSItems.maskScents && event.world.rand.nextInt(32) == 0) {
                    event.drops.add(event.world.rand.nextInt(4) == 0 ? new ItemStack((Block)Blocks.red_mushroom) : new ItemStack((Block)Blocks.brown_mushroom));
                }
            } else if (event.block == Blocks.tallgrass) {
                if (PlayerUtils.isSword(event.harvester.getHeldItem()) && event.world.rand.nextFloat() < Config.getGrassDropChance()) {
                    event.drops.add(ZSSItems.getRandomGrassDrop(event.world.rand));
                }
            } else if (event.block == Blocks.iron_ore && event.world.rand.nextFloat() < 0.005f * (float)event.fortuneLevel) {
                event.drops.add(new ItemStack(ZSSItems.masterOre));
                event.harvester.worldObj.playSoundEffect(event.harvester.posX, event.harvester.posY, event.harvester.posZ, "zeldaswordskills:special_drop", 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        EntityItem item = event.entityItem;
        ItemStack stack = item.getEntityItem();
        if (stack != null) {
            TileEntityDungeonCore core;
            if (stack.getItem() instanceof IHandleToss) {
                ((IHandleToss)stack.getItem()).onItemTossed(item, event.player);
            }
            if (!item.isDead && (stack.getItem() == Items.emerald || stack.getItem() instanceof IFairyUpgrade && ((IFairyUpgrade)stack.getItem()).hasFairyUpgrade(stack)) && (core = WorldUtils.getNearbyFairySpawner(item.worldObj, item.posX, item.posY, item.posZ, true)) != null) {
                core.scheduleItemUpdate(event.player);
            }
        }
        event.setCanceled(item.isDead);
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack = event.item.getEntityItem();
        EntityPlayer player = event.entityPlayer;
        if (stack != null && stack.getItem() instanceof IHandlePickup) {
            int size = stack.stackSize;
            if (((IHandlePickup)stack.getItem()).onPickupItem(stack, player)) {
                if (stack.stackSize < size) {
                    FMLCommonHandler.instance().firePlayerItemPickupEvent(player, event.item);
                    event.item.playSound("random.pop", 0.2f, ((event.item.worldObj.rand.nextFloat() - event.item.worldObj.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    player.onItemPickup((Entity)event.item, size - stack.stackSize);
                }
                if (stack.stackSize <= 0) {
                    event.item.setDead();
                    event.setCanceled(true);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        ItemStack stack = event.entityPlayer.getHeldItem();
        switch (event.action) {
            case LEFT_CLICK_BLOCK: {
                if (stack == null || !(stack.getItem() instanceof ISmashBlock) || event.entityPlayer.attackTime != 0 || !this.blockWasSmashed(event.entityPlayer.worldObj, event.entityPlayer, stack, event.x, event.y, event.z, event.face)) break;
                if (event.entityPlayer instanceof EntityPlayerMP) {
                    ZSSCombatEvents.setPlayerAttackTime(event.entityPlayer);
                    PacketDispatcher.sendTo(new UnpressKeyPacket(-100), (EntityPlayerMP)event.entityPlayer);
                }
                event.useBlock = Event.Result.DENY;
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                if (stack == null || !(stack.getItem() instanceof ILiftBlock) || !this.blockWasLifted(event.entityPlayer.worldObj, event.entityPlayer, stack, event.x, event.y, event.z, event.face)) break;
                event.useBlock = Event.Result.DENY;
                break;
            }
        }
    }

    private boolean blockWasLifted(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        Block block = world.getBlock(x, y, z);
        if (player.canPlayerEdit(x, y, z, side, stack) || block instanceof ILiftable) {
            float resistance;
            boolean isValidBlock;
            int meta = world.getBlockMetadata(x, y, z);
            boolean isLiftable = block instanceof ILiftable;
            boolean bl = isValidBlock = (block.isOpaqueCube() || block instanceof BlockBreakable) && Item.getItemFromBlock((Block)block) != null;
            BlockWeight weight = isLiftable ? ((ILiftable)block).getLiftWeight(player, stack, meta, side) : (Config.canLiftVanilla() ? null : BlockWeight.IMPOSSIBLE);
            float strength = ((ILiftBlock)stack.getItem()).getLiftStrength((EntityPlayer)player, (ItemStack)stack, (Block)block, (int)meta).weight;
            float f = resistance = weight != null ? weight.weight : block.getExplosionResistance(null, world, x, y, z, (double)x, (double)y, (double)z) * 5.0f / 3.0f;
            if (isValidBlock && weight != BlockWeight.IMPOSSIBLE && strength >= resistance && (isLiftable || !block.hasTileEntity(meta))) {
                if (!world.isRemote) {
                    ItemStack returnStack = ((ILiftBlock)stack.getItem()).onLiftBlock(player, stack, block, meta);
                    if (returnStack != null && returnStack.stackSize <= 0) {
                        returnStack = null;
                    }
                    ItemStack heldBlock = ItemHeldBlock.getBlockStack(block, meta, returnStack);
                    if (isLiftable) {
                        ((ILiftable)block).onLifted(world, player, heldBlock, x, y, z, meta);
                    }
                    player.setCurrentItemOrArmor(0, heldBlock);
                    world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.stepSound.getBreakSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                    world.setBlockToAir(x, y, z);
                }
                return true;
            }
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:grunt", 0.3f, 0.8f);
        }
        return false;
    }

    private boolean blockWasSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        Block block = world.getBlock(x, y, z);
        boolean isSmashable = block instanceof ISmashable;
        Event.Result smashResult = Event.Result.DEFAULT;
        boolean wasDestroyed = false;
        if (player.canPlayerEdit(x, y, z, side, stack) || isSmashable) {
            int meta = world.getBlockMetadata(x, y, z);
            BlockWeight weight = isSmashable ? ((ISmashable)block).getSmashWeight(player, stack, meta, side) : (Config.canSmashVanilla() || this.isVanillaBlockSmashable(block) ? null : BlockWeight.IMPOSSIBLE);
            float strength = ((ISmashBlock)stack.getItem()).getSmashStrength((EntityPlayer)player, (ItemStack)stack, (Block)block, (int)meta).weight;
            float resistance = weight != null ? weight.weight : block.getExplosionResistance(null, world, x, y, z, (double)x, (double)y, (double)z) * 5.0f / 3.0f;
            Event.Result result = smashResult = isSmashable ? ((ISmashable)block).onSmashed(world, player, stack, x, y, z, side) : smashResult;
            if (smashResult == Event.Result.DEFAULT) {
                boolean isValidBlock;
                boolean bl = isValidBlock = block.isOpaqueCube() || block instanceof BlockBreakable;
                if (isValidBlock && weight != BlockWeight.IMPOSSIBLE && strength >= resistance && (!block.hasTileEntity(meta) || isSmashable)) {
                    if (!(block instanceof BlockBreakable)) {
                        world.playSoundAtEntity((Entity)player, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
                    }
                    if (!world.isRemote) {
                        world.func_147480_a(x, y, z, false);
                    }
                    wasDestroyed = true;
                }
            }
            ((ISmashBlock)stack.getItem()).onBlockSmashed(player, stack, block, meta, smashResult == Event.Result.ALLOW || wasDestroyed);
        }
        return smashResult == Event.Result.ALLOW || wasDestroyed;
    }

    private boolean isVanillaBlockSmashable(Block block) {
        return block.getMaterial() == Material.glass || block.getMaterial() == Material.ice;
    }

    private static void init() {
        ZSSItemEvents.addDrop(EntityCreeper.class, SkillBase.armorBreak);
        ZSSItemEvents.addDrop(EntityIronGolem.class, SkillBase.armorBreak);
        ZSSItemEvents.addDrop(EntitySilverfish.class, SkillBase.dash);
        ZSSItemEvents.addDrop(EntityHorse.class, SkillBase.dash);
        ZSSItemEvents.addDrop(EntityEnderman.class, SkillBase.dodge);
        ZSSItemEvents.addDrop(EntityKeese.class, SkillBase.dodge);
        ZSSItemEvents.addDrop(EntitySpider.class, SkillBase.endingBlow);
        ZSSItemEvents.addDrop(EntityCaveSpider.class, SkillBase.leapingBlow);
        ZSSItemEvents.addDrop(EntityMagmaCube.class, SkillBase.leapingBlow);
        ZSSItemEvents.addDrop(EntityPigZombie.class, SkillBase.parry);
        ZSSItemEvents.addDrop(EntityOcelot.class, SkillBase.parry);
        ZSSItemEvents.addDrop(EntityOctorok.class, SkillBase.risingCut);
        ZSSItemEvents.addDrop(EntityBlaze.class, SkillBase.spinAttack);
        ZSSItemEvents.addDrop(EntityDarknut.class, SkillBase.spinAttack);
        ZSSItemEvents.addDrop(EntityZombie.class, SkillBase.swordBasic);
        ZSSItemEvents.addDrop(EntitySkeleton.class, SkillBase.swordBasic);
        ZSSItemEvents.addDrop(EntityGhast.class, SkillBase.swordBeam);
        ZSSItemEvents.addDrop(EntityWitch.class, SkillBase.swordBeam);
        ZSSItemEvents.addDrop(EntityWizzrobe.class, SkillBase.swordBreak);
    }
}

