/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.handler;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.INpc;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import zeldaswordskills.api.entity.NpcHelper;
import zeldaswordskills.api.item.IRightClickEntity;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ZSSVillagerInfo;
import zeldaswordskills.entity.ai.EntityAITeleport;
import zeldaswordskills.entity.ai.IEntityTeleport;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.npc.EntityGoron;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.LeapingBlow;
import zeldaswordskills.util.PlayerUtils;

public class ZSSEntityEvents {
    @SubscribeEvent(receiveCanceled=true)
    public void onFall(LivingFallEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
            ZSSPlayerSkills skills = info.getPlayerSkills();
            if (skills.isSkillActive(SkillBase.leapingBlow)) {
                ((LeapingBlow)skills.getPlayerSkill(SkillBase.leapingBlow)).onImpact(player, event.distance);
            }
            if (!event.isCanceled() && info.reduceFallAmount > 0.0f) {
                event.distance -= info.reduceFallAmount;
                info.reduceFallAmount = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onCreativeFall(PlayerFlyableFallEvent event) {
        ZSSPlayerSkills skills = ZSSPlayerSkills.get(event.entityPlayer);
        if (skills.isSkillActive(SkillBase.leapingBlow)) {
            ((LeapingBlow)skills.getPlayerSkill(SkillBase.leapingBlow)).onImpact(event.entityPlayer, event.distance);
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        ItemStack helm;
        if (event.entityLiving.getHeldItem() != null && event.entityLiving.getHeldItem().getItem() == ZSSItems.rocsFeather) {
            event.entityLiving.motionY = event.entityLiving.motionY + (event.entityLiving.isSprinting() ? 0.3 : 0.15);
        }
        if (event.entityLiving.getEquipmentInSlot(1) != null && event.entityLiving.getEquipmentInSlot(1).getItem() == ZSSItems.bootsPegasus) {
            event.entityLiving.motionY += 0.15;
            if (event.entity instanceof EntityPlayer) {
                ZSSPlayerInfo.get((EntityPlayer)((EntityPlayer)event.entity)).reduceFallAmount += 1.0f;
            }
        }
        if ((helm = event.entityLiving.getEquipmentInSlot(4)) != null) {
            if (helm.getItem() == ZSSItems.maskBunny) {
                event.entityLiving.motionY += 0.3;
                if (event.entity instanceof EntityPlayer) {
                    ZSSPlayerInfo.get((EntityPlayer)((EntityPlayer)event.entity)).reduceFallAmount += 5.0f;
                }
            } else if (helm.getItem() == ZSSItems.maskDeku) {
                event.entityLiving.motionY += 0.3;
            }
        }
    }

    @SubscribeEvent
    public void onInteract(EntityInteractEvent event) {
        ItemStack helm;
        ItemStack stack = event.entityPlayer.getHeldItem();
        if (event.target instanceof EntityVillager && Event.Result.DEFAULT != NpcHelper.convertVillager(event.entityPlayer, (EntityVillager)event.target, true)) {
            event.setCanceled(true);
        }
        if (!event.isCanceled() && stack != null && stack.getItem() instanceof IRightClickEntity) {
            event.setCanceled(((IRightClickEntity)stack.getItem()).onRightClickEntity(stack, event.entityPlayer, event.target));
        }
        if (!event.isCanceled() && event.target instanceof INpc && (helm = event.entityPlayer.getCurrentArmor(3)) != null && helm.getItem() instanceof ItemMask) {
            event.setCanceled(((ItemMask)helm.getItem()).onInteract(helm, event.entityPlayer, event.target));
        }
        if (!event.isCanceled() && stack != null && stack.getItem() == Items.glass_bottle && event.target.getClass() == EntityCow.class) {
            event.setCanceled(ZSSPlayerSongs.get(event.entityPlayer).milkLonLonCow(event.entityPlayer, (EntityCow)event.target));
        }
        if (!event.isCanceled() && event.target.getClass() == EntityVillager.class && "Cursed Man".equals(((EntityVillager)event.target).getCustomNameTag())) {
            EntityVillager villager = (EntityVillager)event.target;
            if (stack == null || stack.getItem() != ZSSItems.skulltulaToken && stack.getItem() != Items.name_tag) {
                int tokens = ZSSPlayerInfo.get(event.entityPlayer).getSkulltulaTokens();
                if (!villager.worldObj.isRemote) {
                    if (villager.isChild()) {
                        PlayerUtils.sendTranslatedChat(event.entityPlayer, "chat.zss.npc.cursed_man.child", new Object[0]);
                    } else if (tokens > 0) {
                        PlayerUtils.sendTranslatedChat(event.entityPlayer, "chat.zss.npc.cursed_man.amount", tokens);
                    } else {
                        PlayerUtils.sendTranslatedChat(event.entityPlayer, "chat.zss.npc.cursed_man." + event.entity.worldObj.rand.nextInt(4), new Object[0]);
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ZSSPlayerInfo.get(player).onUpdate();
            if (player.motionY < -0.25) {
                boolean flag;
                boolean bl = flag = player.getHeldItem() != null && player.getHeldItem().getItem() == ZSSItems.rocsFeather;
                if (flag || player.getCurrentArmor(3) != null && player.getCurrentArmor(3).getItem() == ZSSItems.maskDeku) {
                    player.motionY = -0.25;
                    player.fallDistance = 0.0f;
                }
            }
        }
        if (event.entity instanceof EntityLivingBase) {
            ZSSEntityInfo.get((EntityLivingBase)event.entity).onUpdate();
        }
        if (event.entity instanceof EntityVillager) {
            ZSSVillagerInfo.get((EntityVillager)event.entity).onUpdate();
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        ZSSEntityInfo.get((EntityLivingBase)event.entityPlayer).copy(ZSSEntityInfo.get((EntityLivingBase)event.original));
        ZSSPlayerInfo.get(event.entityPlayer).copy(ZSSPlayerInfo.get(event.original));
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            ZSSEntityInfo.get((EntityLivingBase)((EntityPlayer)event.entity)).onJoinWorld();
            ZSSPlayerInfo.get((EntityPlayer)event.entity).onJoinWorld();
        }
        if (!event.entity.worldObj.isRemote) {
            if (event.entity.getClass() == EntityVillager.class) {
                EntityGoron.doVillagerSpawn((EntityVillager)event.entity, event.entity.worldObj);
            }
            if (!Config.areVanillaBuffsDisabled() && event.entity instanceof EntityLivingBase) {
                this.initBuffs((EntityLivingBase)event.entity);
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase && ZSSEntityInfo.get((EntityLivingBase)event.entity) == null) {
            ZSSEntityInfo.register((EntityLivingBase)event.entity);
        }
        if (event.entity instanceof EntityVillager && ZSSVillagerInfo.get((EntityVillager)event.entity) == null) {
            ZSSVillagerInfo.register((EntityVillager)event.entity);
        }
        if (event.entity instanceof EntityPlayer && ZSSPlayerInfo.get((EntityPlayer)event.entity) == null) {
            ZSSPlayerInfo.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void postTeleport(EntityAITeleport.PostEnderTeleport event) {
        EntityAITeleport.disruptTargeting(event.entityLiving);
        if (event.entity instanceof IEntityTeleport) {
            ((IEntityTeleport)event.entity).getTeleportAI().onPostTeleport(event.targetX, event.targetY, event.targetZ);
        }
    }

    private void initBuffs(EntityLivingBase entity) {
        if (!ZSSEntityInfo.get(entity).getActiveBuffs().isEmpty()) {
            return;
        }
        if (entity.isImmuneToFire()) {
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 75);
            ZSSEntityInfo.get(entity).applyBuff(Buff.WEAKNESS_COLD, Integer.MAX_VALUE, 100);
        }
        if (entity.getCreatureAttribute() == EnumCreatureAttribute.UNDEAD) {
            if (!entity.isImmuneToFire()) {
                ZSSEntityInfo.get(entity).applyBuff(Buff.WEAKNESS_FIRE, Integer.MAX_VALUE, 50);
            }
            ZSSEntityInfo.get(entity).applyBuff(Buff.WEAKNESS_HOLY, Integer.MAX_VALUE, 300);
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 50);
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 50);
        }
        if (entity instanceof EntityGolem) {
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 100);
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 100);
        }
        if (entity instanceof EntityWitch) {
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_MAGIC, Integer.MAX_VALUE, 75);
        }
        if (entity instanceof EntityWither) {
            ZSSEntityInfo.get(entity).removeBuff(Buff.WEAKNESS_COLD);
        }
    }
}

