/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.handler;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Set;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.damage.EnumDamageType;
import zeldaswordskills.api.damage.IDamageAoE;
import zeldaswordskills.api.damage.IDamageType;
import zeldaswordskills.api.damage.IPostDamageEffect;
import zeldaswordskills.api.item.IArmorBreak;
import zeldaswordskills.api.item.ISwingSpeed;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.item.ItemArmorTunic;
import zeldaswordskills.item.ItemFairyBottle;
import zeldaswordskills.item.ItemZeldaShield;
import zeldaswordskills.item.ItemZeldaSword;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.UnpressKeyPacket;
import zeldaswordskills.network.server.AddExhaustionPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.ArmorBreak;
import zeldaswordskills.skills.sword.MortalDraw;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class ZSSCombatEvents {
    public static void setPlayerAttackTime(EntityPlayer player) {
        if (!player.capabilities.isCreativeMode) {
            ItemStack stack = player.getHeldItem();
            int nextSwing = Config.getBaseSwingSpeed();
            if (stack != null && stack.getItem() instanceof ISwingSpeed) {
                nextSwing += Math.max(player.attackTime, ((ISwingSpeed)stack.getItem()).getSwingSpeed());
                if (player.worldObj.isRemote) {
                    float exhaustion = ((ISwingSpeed)stack.getItem()).getExhaustion();
                    if (exhaustion > 0.0f) {
                        PacketDispatcher.sendToServer(new AddExhaustionPacket(exhaustion));
                    }
                } else {
                    PacketDispatcher.sendTo(new UnpressKeyPacket(-100), (EntityPlayerMP)player);
                }
            }
            player.attackTime = Math.max(player.attackTime, nextSwing);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onPlayerAttack(AttackEntityEvent event) {
        if (!event.entityPlayer.worldObj.isRemote) {
            ZSSCombatEvents.setPlayerAttackTime(event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onSetAttackTarget(LivingSetAttackTargetEvent event) {
        ItemStack mask;
        if (event.target instanceof EntityPlayer && event.entity instanceof EntityLiving && (mask = ((EntityPlayer)event.target).getCurrentArmor(3)) != null && mask.getItem() == ZSSItems.maskSpooky && event.entityLiving.func_94060_bK() != event.target) {
            ((EntityLiving)event.entity).setAttackTarget(null);
        }
    }

    @SubscribeEvent
    public void onAttacked(LivingAttackEvent event) {
        EntityLivingBase entity;
        float evade;
        if (event.source.getEntity() instanceof EntityLivingBase) {
            event.setCanceled(ZSSEntityInfo.get((EntityLivingBase)event.source.getEntity()).isBuffActive(Buff.STUN));
        }
        float amount = ZSSCombatEvents.applyDamageModifiers(event.entityLiving, event.source, event.ammount);
        if (!event.isCanceled() && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ZSSPlayerSkills.get(player).onBeingAttacked(event);
            if (amount < 0.1f) {
                event.setCanceled(true);
            } else if (!event.isCanceled() && event.source.isFireDamage() && event.source.getSourceOfDamage() == null) {
                event.setCanceled(ItemArmorTunic.onFireDamage((EntityLivingBase)player, event.ammount));
            }
        } else if (amount < 0.1f) {
            event.setCanceled(true);
        } else if (!(event.isCanceled() || event.source.getEntity() == null || event.source instanceof IDamageAoE && ((IDamageAoE)event.source).isAoEDamage() || !((evade = (float)ZSSEntityInfo.get(entity = event.entityLiving).getBuffAmplifier(Buff.EVADE_UP) * 0.01f) > 0.0f) || ZSSEntityInfo.get(entity).isBuffActive(Buff.STUN))) {
            float penalty = (float)ZSSEntityInfo.get(entity).getBuffAmplifier(Buff.EVADE_DOWN) * 0.01f;
            if (entity.worldObj.rand.nextFloat() < evade - penalty) {
                WorldUtils.playSoundAtEntity((Entity)entity, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPreHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (event.entity instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.entity).getHeldItem()) != null && stack.getItem() instanceof ItemZeldaShield && player.isUsingItem()) {
            Entity opponent;
            ItemZeldaShield shield = (ItemZeldaShield)stack.getItem();
            if (ZSSPlayerInfo.get(player).canBlock() && shield.canBlockDamage(stack, event.source) && (opponent = event.source.getEntity()) != null && TargetUtils.isTargetInFrontOf(opponent, (Entity)player, 60.0f)) {
                event.ammount = shield.onBlock(player, stack, event.source, event.ammount);
                event.setCanceled(event.ammount < 0.1f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHurt(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.source.getEntity() instanceof EntityPlayer && !(event.source instanceof DamageUtils.DamageSourceArmorBreak)) {
            player = (EntityPlayer)event.source.getEntity();
            ZSSPlayerSkills skills = ZSSPlayerSkills.get(player);
            ICombo combo = skills.getComboSkill();
            if (combo != null && combo.isComboInProgress()) {
                event.ammount += (float)combo.getCombo().getNumHits();
            }
            if (skills.isSkillActive(SkillBase.armorBreak)) {
                ((ArmorBreak)skills.getPlayerSkill(SkillBase.armorBreak)).onImpact(player, event);
                return;
            }
            if (skills.isSkillActive(SkillBase.mortalDraw)) {
                ((MortalDraw)skills.getPlayerSkill(SkillBase.mortalDraw)).onImpact(player, event);
            }
            if (player.getHeldItem() != null && player.getHeldItem().getItem() instanceof IArmorBreak && event.source.damageType.equals("player")) {
                float damage = event.ammount * ((IArmorBreak)player.getHeldItem().getItem()).getPercentArmorIgnored() * 0.01f;
                DirtyEntityAccessor.damageEntity(event.entityLiving, DamageUtils.causeIArmorBreakDamage((Entity)player), damage);
                event.ammount -= damage;
            }
        }
        event.ammount = ZSSCombatEvents.applyDamageModifiers(event.entityLiving, event.source, event.ammount);
        if (event.ammount > 0.0f && event.entity instanceof EntityPlayer) {
            player = (EntityPlayer)event.entity;
            if (event.isCanceled()) {
                return;
            }
            ICombo combo = ZSSPlayerSkills.get(player).getComboSkill();
            if (combo != null && event.ammount > 0.0f) {
                combo.onPlayerHurt(player, event);
            }
        }
        if (event.ammount > 0.0f && event.source.getEntity() instanceof EntityPlayer) {
            ZSSPlayerSkills.get((EntityPlayer)event.source.getEntity()).onPostImpact(event);
        }
        ZSSCombatEvents.handleSecondaryEffects(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!event.entity.worldObj.isRemote && event.entity instanceof EntityPlayer) {
            event.setCanceled(ItemFairyBottle.onDeath((EntityPlayer)event.entity));
        }
        if (event.source.getEntity() instanceof EntityPlayer && event.entity instanceof IMob) {
            ItemZeldaSword.onKilledMob((EntityPlayer)event.source.getEntity(), (IMob)event.entity);
        }
    }

    public static float applyDamageModifiers(EntityLivingBase defender, DamageSource source, float amount) {
        if (source.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)source.getEntity();
            amount *= 1.0f - (float)ZSSEntityInfo.get(entity).getBuffAmplifier(Buff.ATTACK_DOWN) * 0.01f;
            amount *= 1.0f + (float)ZSSEntityInfo.get(entity).getBuffAmplifier(Buff.ATTACK_UP) * 0.01f;
        }
        amount = ZSSCombatEvents.applyDamageWeaknesses(defender, source, amount);
        amount = ZSSCombatEvents.applyDamageResistances(defender, source, amount);
        return amount;
    }

    private static float applyDamageResistances(EntityLivingBase defender, DamageSource source, float amount) {
        Set<EnumDamageType> damageTypes;
        ZSSEntityInfo info = ZSSEntityInfo.get(defender);
        float defenseUp = (float)info.getBuffAmplifier(Buff.DEFENSE_UP) * 0.01f;
        float defenseDown = (float)info.getBuffAmplifier(Buff.DEFENSE_DOWN) * 0.01f;
        amount *= 1.0f + defenseDown - defenseUp;
        if (source instanceof IDamageType && amount > 0.0f && (damageTypes = ((IDamageType)source).getEnumDamageTypes()) != null) {
            for (EnumDamageType type : damageTypes) {
                if (EnumDamageType.damageResistMap.get((Object)type) == null) continue;
                amount *= 1.0f - (float)info.getBuffAmplifier(EnumDamageType.damageResistMap.get((Object)type)) * 0.01f;
            }
        }
        if (source.isFireDamage()) {
            amount *= 1.0f - (float)info.getBuffAmplifier(Buff.RESIST_FIRE) * 0.01f;
        }
        if (source.isMagicDamage()) {
            amount *= 1.0f - (float)info.getBuffAmplifier(Buff.RESIST_MAGIC) * 0.01f;
        }
        return amount;
    }

    private static float applyDamageWeaknesses(EntityLivingBase defender, DamageSource source, float amount) {
        Set<EnumDamageType> damageTypes;
        ZSSEntityInfo info = ZSSEntityInfo.get(defender);
        if (source instanceof IDamageType && (damageTypes = ((IDamageType)source).getEnumDamageTypes()) != null) {
            for (EnumDamageType type : damageTypes) {
                if (EnumDamageType.damageWeaknessMap.get((Object)type) == null) continue;
                amount *= 1.0f + (float)info.getBuffAmplifier(EnumDamageType.damageWeaknessMap.get((Object)type)) * 0.01f;
            }
        }
        if (source.isFireDamage()) {
            amount *= 1.0f + (float)info.getBuffAmplifier(Buff.WEAKNESS_FIRE) * 0.01f;
        }
        if (source.isMagicDamage()) {
            amount *= 1.0f + (float)info.getBuffAmplifier(Buff.WEAKNESS_MAGIC) * 0.01f;
        }
        return amount;
    }

    private static void handleSecondaryEffects(LivingHurtEvent event) {
        Set<EnumDamageType> damageTypes;
        if (event.ammount >= 1.0f && event.source instanceof IDamageType && event.source instanceof IPostDamageEffect && (damageTypes = ((IDamageType)event.source).getEnumDamageTypes()) != null) {
            for (EnumDamageType type : damageTypes) {
                type.handleSecondaryEffects((IPostDamageEffect)event.source, event.entityLiving, event.ammount);
            }
        }
    }
}

