/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.handler;

import cpw.mods.fml.common.network.IGuiHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.block.tileentity.TileEntityGossipStone;
import zeldaswordskills.block.tileentity.TileEntityPedestal;
import zeldaswordskills.client.gui.GuiEditGossipStone;
import zeldaswordskills.client.gui.GuiLearnSong;
import zeldaswordskills.client.gui.GuiMaskTrader;
import zeldaswordskills.client.gui.GuiOcarina;
import zeldaswordskills.client.gui.GuiPedestal;
import zeldaswordskills.client.gui.GuiSkills;
import zeldaswordskills.entity.npc.EntityNpcMaskTrader;
import zeldaswordskills.inventory.ContainerMaskTrader;
import zeldaswordskills.inventory.ContainerPedestal;
import zeldaswordskills.inventory.ContainerSkills;

public class GuiHandler
implements IGuiHandler {
    public static final int GUI_PEDESTAL = 0;
    public static final int GUI_MASK_TRADER = 1;
    public static final int GUI_SKILLS = 2;
    public static final int GUI_OCARINA = 3;
    public static final int GUI_SCARECROW = 4;
    public static final int GUI_LEARN_SONG = 5;
    public static final int GUI_EDIT_GOSSIP_STONE = 6;

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (id) {
            case 0: {
                TileEntity te = world.getTileEntity(x, y, z);
                if (te instanceof TileEntityPedestal) {
                    return new ContainerPedestal(player.inventory, (TileEntityPedestal)te);
                }
                return null;
            }
            case 1: {
                Entity merchant = world.getEntityByID(x);
                if (merchant instanceof EntityNpcMaskTrader) {
                    return new ContainerMaskTrader((EntityNpcMaskTrader)merchant);
                }
                return null;
            }
            case 2: {
                return new ContainerSkills(player);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        switch (id) {
            case 0: {
                if (te instanceof TileEntityPedestal) {
                    return new GuiPedestal(player.inventory, (TileEntityPedestal)te);
                }
                return null;
            }
            case 1: {
                Entity merchant = world.getEntityByID(x);
                if (merchant instanceof EntityNpcMaskTrader) {
                    return new GuiMaskTrader((EntityNpcMaskTrader)merchant);
                }
                return null;
            }
            case 2: {
                return new GuiSkills(player);
            }
            case 3: {
                return new GuiOcarina(MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY), MathHelper.floor_double((double)player.posZ));
            }
            case 6: {
                if (te == null) {
                    te = new TileEntityGossipStone();
                    te.setWorldObj(world);
                    te.xCoord = x;
                    te.yCoord = y;
                    te.zCoord = z;
                }
                if (te instanceof TileEntityGossipStone) {
                    return new GuiEditGossipStone((TileEntityGossipStone)te);
                }
                return null;
            }
            case 4: {
                return new GuiOcarina(MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY), MathHelper.floor_double((double)player.posZ), true);
            }
            case 5: {
                try {
                    return new GuiLearnSong(MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY), MathHelper.floor_double((double)player.posZ));
                }
                catch (IllegalArgumentException e) {
                    ZSSMain.logger.error(e.getMessage());
                    return null;
                }
            }
        }
        return null;
    }
}

