/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import net.minecraft.block.Block;
import net.minecraft.block.BlockButtonWood;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.util.WorldUtils;

public class EntitySeedShot
extends EntityMobThrowable {
    protected static final int CRITICAL_INDEX = 22;
    protected static final int SEEDTYPE_INDEX = 23;
    private int knockback = 0;

    public EntitySeedShot(World world) {
        super(world);
        this.setGravityVelocity(0.05f);
    }

    public EntitySeedShot(World world, EntityLivingBase entity, float velocity) {
        this(world, entity, velocity, 1, 0.0f);
    }

    public EntitySeedShot(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
        this.setGravityVelocity(0.05f);
    }

    public EntitySeedShot(World world, EntityLivingBase entity, float velocity, int n, float spread) {
        super(world, entity);
        this.setGravityVelocity(0.05f);
        if (n > 1) {
            this.setLocationAndAngles(entity.posX, entity.posY + (double)entity.getEyeHeight(), entity.posZ, entity.rotationYaw, entity.rotationPitch);
            float rotFactor = (float)(n / 2) * spread;
            this.rotationYaw += rotFactor * (float)(n % 2 == 0 ? 1 : -1);
            this.posX -= (double)(MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
            this.posY -= (double)0.1f;
            this.posZ -= (double)(MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
            this.setPosition(this.posX, this.posY, this.posZ);
            this.yOffset = 0.0f;
            float f = 0.4f;
            this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI)) * f;
            this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI)) * f;
            this.motionY = -MathHelper.sin((float)((this.rotationPitch + this.func_70183_g()) / 180.0f * (float)Math.PI)) * f;
        }
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, velocity * 1.5f, 1.0f);
    }

    public EntitySeedShot(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.setGravityVelocity(0.05f);
    }

    public void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(22, (Object)0);
        this.dataWatcher.addObject(23, (Object)SeedType.GRASS.ordinal());
    }

    public void setIsCritical(boolean isCrit) {
        this.dataWatcher.updateObject(22, (Object)((byte)(isCrit ? 1 : 0)));
    }

    public boolean getIsCritical() {
        return this.dataWatcher.getWatchableObjectByte(22) > 0;
    }

    public EntitySeedShot setType(SeedType type) {
        this.dataWatcher.updateObject(23, (Object)type.ordinal());
        return this;
    }

    public SeedType getType() {
        return SeedType.values()[this.dataWatcher.getWatchableObjectInt(23) % SeedType.values().length];
    }

    public DamageSource getDamageSource() {
        switch (this.getType()) {
            case BOMB: {
                return new DamageUtils.DamageSourceBaseIndirect("slingshot", (Entity)this, (Entity)this.getThrower()).setExplosion().setProjectile();
            }
            case DEKU: {
                return new DamageUtils.DamageSourceBaseIndirect("slingshot", (Entity)this, (Entity)this.getThrower()).setStunDamage(80, 2, true).setProjectile();
            }
            case NETHERWART: {
                return new EntityDamageSourceIndirect("slingshot", (Entity)this, (Entity)this.getThrower()).setFireDamage().setProjectile();
            }
        }
        return new EntityDamageSourceIndirect("slingshot", (Entity)this, (Entity)this.getThrower()).setProjectile();
    }

    public void setKnockback(int value) {
        this.knockback = value;
    }

    public int getKnockback() {
        return this.knockback;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.entityHit != null) {
            if (this.isBurning() && !(mop.entityHit instanceof EntityEnderman)) {
                mop.entityHit.setFire(5);
            }
            if (this.getType() == SeedType.BOMB) {
                CustomExplosion.createExplosion(new EntityBomb(this.worldObj, this.getThrower()), this.worldObj, this.posX, this.posY, this.posZ, 3.0f, SeedType.BOMB.getDamage(), false);
                this.setDead();
            } else if (mop.entityHit.attackEntityFrom(this.getDamageSource(), this.calculateDamage())) {
                float f;
                this.playSound("game.neutral.hurt", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                if (this.knockback > 0 && (f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ))) > 0.0f) {
                    double d = (double)this.knockback * (double)0.6f / (double)f;
                    mop.entityHit.addVelocity(this.motionX * d, 0.1, this.motionZ * d);
                }
                if (mop.entityHit instanceof EntityLivingBase) {
                    EntityLivingBase entity = (EntityLivingBase)mop.entityHit;
                    switch (this.getType()) {
                        case COCOA: {
                            entity.addPotionEffect(new PotionEffect(Potion.weakness.id, 100, 0));
                            break;
                        }
                        case PUMPKIN: {
                            entity.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 100, 0));
                            break;
                        }
                    }
                    if (this.getThrower() instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)mop.entityHit), (Entity)this.getThrower());
                        EnchantmentHelper.func_151385_b((EntityLivingBase)this.getThrower(), (Entity)mop.entityHit);
                    }
                }
                if (!(mop.entityHit instanceof EntityEnderman)) {
                    this.setDead();
                }
            } else {
                this.motionX *= (double)-0.1f;
                this.motionY *= (double)-0.1f;
                this.motionZ *= (double)-0.1f;
                this.rotationYaw += 180.0f;
                this.prevRotationYaw += 180.0f;
            }
        } else {
            boolean flag;
            Block block = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
            if (block.getMaterial() != Material.air) {
                block.onEntityCollidedWithBlock(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, (Entity)this);
            }
            boolean bl = flag = !block.getBlocksMovement((IBlockAccess)this.worldObj, mop.blockX, mop.blockY, mop.blockZ);
            if (this.getType() == SeedType.BOMB && flag) {
                double dz;
                double dy;
                double dx;
                double d = mop.sideHit == 3 ? -0.5 : (dx = mop.sideHit == 2 ? 0.5 : 0.0);
                double d2 = mop.sideHit == 0 ? -0.5 : (dy = mop.sideHit == 1 ? 0.5 : 0.0);
                double d3 = mop.sideHit == 4 ? -0.5 : (dz = mop.sideHit == 5 ? 0.5 : 0.0);
                if (!this.worldObj.isRemote) {
                    CustomExplosion.createExplosion(new EntityBomb(this.worldObj, this.getThrower()), this.worldObj, this.posX + dx, this.posY + dy, this.posZ + dz, 3.0f, SeedType.BOMB.getDamage(), false);
                }
            } else if (block instanceof BlockButtonWood) {
                WorldUtils.activateButton(this.worldObj, block, mop.blockX, mop.blockY, mop.blockZ);
                flag = true;
            }
            if (flag) {
                this.playSound("game.neutral.hurt", 0.3f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                this.setDead();
            }
        }
        if (!this.isEntityAlive()) {
            String particle = this.getType().particleName;
            for (int i = 0; i < 4; ++i) {
                this.worldObj.spawnParticle(particle, this.posX - this.motionX * (double)i / 4.0, this.posY - this.motionY * (double)i / 4.0, this.posZ - this.motionZ * (double)i / 4.0, this.motionX, this.motionY + 0.2, this.motionZ);
            }
        }
    }

    protected float calculateDamage() {
        float f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
        float dmg = f * this.getDamage();
        if (this.getIsCritical()) {
            dmg += this.rand.nextFloat() * (this.getDamage() / 4.0f) + 0.25f;
        }
        return dmg;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setBoolean("isCritical", this.getIsCritical());
        compound.setByte("seedType", (byte)this.getType().ordinal());
        compound.setInteger("knockback", this.knockback);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.setIsCritical(compound.getBoolean("isCritical"));
        this.setType(SeedType.values()[compound.getByte("seedType") % SeedType.values().length]);
        this.knockback = compound.getInteger("knockback");
    }

    public static enum SeedType {
        NONE(0.0f, "crit"),
        BOMB(3.0f, "largeexplode"),
        COCOA(1.25f, "crit"),
        DEKU(1.5f, "largeexplode"),
        GRASS(1.0f, "crit"),
        MELON(1.25f, "crit"),
        NETHERWART(1.5f, "crit"),
        PUMPKIN(1.25f, "crit");

        private final float damage;
        public final String particleName;

        private SeedType(float damage, String particle) {
            this.damage = damage;
            this.particleName = particle;
        }

        public float getDamage() {
            return this.damage;
        }
    }
}

