/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityMobThrowable
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private int throwerId;
    private float damage;
    private float gravity = 0.03f;

    public EntityMobThrowable(World world) {
        super(world);
    }

    public EntityMobThrowable(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityMobThrowable(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityMobThrowable(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter);
        this.posY = shooter.posY + (double)shooter.getEyeHeight() - (double)0.1f;
        double d0 = target.posX - shooter.posX;
        double d1 = target.boundingBox.minY + (double)(target.height / 3.0f) - this.posY;
        double d2 = target.posZ - shooter.posZ;
        double d3 = MathHelper.sqrt_double((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.setLocationAndAngles(shooter.posX + d4, this.posY, shooter.posZ + d5, f2, f3);
            this.yOffset = 0.0f;
            float f4 = (float)d3 * 0.2f;
            this.setThrowableHeading(d0, d1 + (double)f4, d2, velocity, wobble);
        }
    }

    public EntityLivingBase getThrower() {
        EntityLivingBase thrower = super.getThrower();
        if (thrower == null) {
            Entity entity = this.worldObj.getEntityByID(this.throwerId);
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }
        return thrower;
    }

    public float getDamage() {
        return this.damage;
    }

    public EntityMobThrowable setDamage(float amount) {
        this.damage = amount;
        return this;
    }

    public EntityMobThrowable setProjectileVelocity(float velocity) {
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, velocity, 0.0f);
        return this;
    }

    protected float getGravityVelocity() {
        return this.gravity;
    }

    public EntityMobThrowable setGravityVelocity(float amount) {
        this.gravity = amount;
        return this;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!(this.gravityCheck() && !(this.posY > 255.0) || this.worldObj.isRemote)) {
            this.setDead();
        }
    }

    protected boolean gravityCheck() {
        return this.getGravityVelocity() > 0.0f || this.ticksExisted < 60;
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setInteger("throwerId", this.getThrower() == null ? -1 : this.getThrower().getEntityId());
        compound.setFloat("damage", this.damage);
        compound.setFloat("gravity", this.gravity);
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.throwerId = compound.getInteger("throwerId");
        this.damage = compound.getFloat("damage");
        this.gravity = compound.getFloat("gravity");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.gravity);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.gravity = buffer.readFloat();
    }
}

