/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.WorldUtils;
import zeldaswordskills.world.gen.DungeonLootLists;

public class EntityCeramicJar
extends EntityThrowable {
    private ItemStack stack = null;

    public EntityCeramicJar(World world) {
        super(world);
    }

    public EntityCeramicJar(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityCeramicJar(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityCeramicJar setStack(ItemStack stack) {
        this.stack = stack.copy();
        return this;
    }

    protected float func_70182_d() {
        return 1.0f;
    }

    protected float getGravityVelocity() {
        return 0.1f;
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.entityHit != null) {
            mop.entityHit.attackEntityFrom(DamageSource.causeThrownDamage((Entity)this, (Entity)this.getThrower()), 2.0f);
        }
        for (int i = 0; i < 20; ++i) {
            this.worldObj.spawnParticle("blockcrack_" + Block.getIdFromBlock((Block)ZSSBlocks.ceramicJar) + "_0", this.posX, this.posY, this.posZ, this.motionX + this.rand.nextGaussian(), 0.01, this.motionZ + this.rand.nextGaussian());
        }
        WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:break_jar", 0.4f, 0.5f);
        if (this.stack == null && this.rand.nextFloat() < Config.getJarDropChance()) {
            this.stack = ChestGenHooks.getInfo((String)DungeonLootLists.JAR_DROPS).getOneItem(this.rand);
        }
        if (this.stack != null) {
            WorldUtils.spawnItemWithRandom(this.worldObj, this.stack, (int)this.posX, (int)this.posY + 1, (int)this.posZ);
        }
        if (!this.worldObj.isRemote) {
            this.setDead();
        }
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        if (this.stack != null) {
            NBTTagCompound item = new NBTTagCompound();
            this.stack.writeToNBT(item);
            compound.setTag("jarItem", (NBTBase)item);
        }
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        if (compound.hasKey("jarItem")) {
            this.stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("jarItem"));
        }
    }
}

