/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.entity.projectile.EntityMobThrowable;

public class EntityBombosFireball
extends EntityMobThrowable {
    private int lifespan = 20;

    public EntityBombosFireball(World world) {
        super(world);
        this.setFire(5);
    }

    public EntityBombosFireball(World world, EntityLivingBase thrower) {
        super(world, thrower);
        this.setFire(5);
    }

    public EntityBombosFireball setLifespan(int ticks) {
        this.lifespan = ticks;
        return this;
    }

    @Override
    protected float getGravityVelocity() {
        return 0.015f;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote && this.ticksExisted > this.lifespan) {
            this.setDead();
        }
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote) {
            if (mop.entityHit != null) {
                boolean flag = mop.entityHit.attackEntityFrom((DamageSource)new DamageUtils.DamageSourceFireIndirect("fireball", (Entity)this, (Entity)this.getThrower()), this.getDamage());
                if (flag) {
                    if (this.getThrower() instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)mop.entityHit), (Entity)this.getThrower());
                        EnchantmentHelper.func_151385_b((EntityLivingBase)this.getThrower(), (Entity)mop.entityHit);
                    }
                    if (!mop.entityHit.isImmuneToFire()) {
                        mop.entityHit.setFire(5);
                    }
                }
            } else {
                boolean flag = true;
                if (this.getThrower() instanceof EntityLiving) {
                    flag = this.worldObj.getGameRules().getGameRuleBooleanValue("mobGriefing");
                }
                if (flag) {
                    int i = mop.blockX;
                    int j = mop.blockY;
                    int k = mop.blockZ;
                    switch (mop.sideHit) {
                        case 0: {
                            --j;
                            break;
                        }
                        case 1: {
                            ++j;
                            break;
                        }
                        case 2: {
                            --k;
                            break;
                        }
                        case 3: {
                            ++k;
                            break;
                        }
                        case 4: {
                            --i;
                            break;
                        }
                        case 5: {
                            ++i;
                        }
                    }
                    if (this.worldObj.isAirBlock(i, j, k)) {
                        this.worldObj.setBlock(i, j, k, (Block)Blocks.fire);
                    }
                }
            }
            this.setDead();
        }
    }
}

