/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.entity.IEntityBombEater;
import zeldaswordskills.api.entity.IEntityBombIngestible;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;

public class EntityBomb
extends EntityMobThrowable
implements IEntityBombIngestible {
    private int fuseTime = 24;
    private float radius = 0.0f;
    private boolean canGrief = true;
    protected float motionFactor = 1.0f;
    protected float destructionFactor = 1.0f;
    private static final int BOMBTYPE_DATAWATCHER_INDEX = 22;

    public EntityBomb(World world) {
        super(world);
        this.setGravityVelocity(0.075f);
        this.setSize(0.5f, 0.5f);
    }

    public EntityBomb(World world, EntityLivingBase entity) {
        super(world, entity);
        this.setGravityVelocity(0.075f);
        this.setSize(0.5f, 0.5f);
    }

    public EntityBomb(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.setGravityVelocity(0.075f);
        this.setSize(0.5f, 0.5f);
    }

    public EntityBomb(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
        this.setGravityVelocity(0.075f);
        this.setSize(0.5f, 0.5f);
    }

    public void entityInit() {
        super.entityInit();
        this.setDamage(0.0f);
        this.dataWatcher.addObject(22, (Object)BombType.BOMB_STANDARD.ordinal());
    }

    @Override
    public float getExplosionDamage(Entity entity) {
        return this.getDamage();
    }

    @Override
    public EntityBomb setExplosionDamage(float damage) {
        return (EntityBomb)this.setDamage(damage);
    }

    @Override
    public float getExplosionRadius(Entity entity) {
        return this.getRadius();
    }

    @Override
    public EntityBomb setExplosionRadius(float radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public int getFuseTime(Entity entity) {
        return this.fuseTime;
    }

    @Override
    public EntityBomb setFuseTime(int time) {
        this.fuseTime = Math.max(time, 1);
        return this;
    }

    public EntityBomb addTime(int time) {
        this.fuseTime = Math.max(this.fuseTime + time, this.fuseTime);
        return this;
    }

    public float getRadius() {
        return this.radius > 0.0f ? this.radius : ItemBomb.getRadius(this.getType());
    }

    @Override
    public float getMotionFactor() {
        return this.motionFactor;
    }

    public EntityBomb setMotionFactor(float amount) {
        this.motionFactor = amount;
        return this;
    }

    @Override
    public float getDestructionFactor() {
        return this.destructionFactor;
    }

    public EntityBomb setDestructionFactor(float factor) {
        this.destructionFactor = factor;
        return this;
    }

    public boolean canGriefAdventureMode() {
        return Config.canGriefAdventure();
    }

    public EntityBomb setNoGrief() {
        this.canGrief = false;
        return this;
    }

    @Override
    public BombType getType() {
        return BombType.values()[this.dataWatcher.getWatchableObjectInt(22)];
    }

    public EntityBomb setType(BombType type) {
        this.dataWatcher.updateObject(22, (Object)type.ordinal());
        return this;
    }

    @Override
    public boolean hasPostExplosionEffect() {
        return this.getType() != BombType.BOMB_FLOWER || this.getThrower() == null;
    }

    protected float func_70182_d() {
        return 0.5f;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public AxisAlignedBB getCollisionBox(Entity entity) {
        return entity.boundingBox;
    }

    @Override
    public void onUpdate() {
        boolean inFire;
        super.onUpdate();
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.04f;
        this.noClip = this.func_145771_j(this.posX, (this.boundingBox.minY + this.boundingBox.maxY) / 2.0, this.posZ);
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        float f = 0.98f;
        if (this.onGround) {
            f = 0.58800006f;
            Block block = this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.boundingBox.minY) - 1, MathHelper.floor_double((double)this.posZ));
            if (block.getMaterial() != Material.air) {
                f = block.slipperiness * 0.98f;
            }
        }
        this.motionX *= (double)f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)f;
        if (this.onGround) {
            this.motionY *= -0.5;
        }
        if (!this.worldObj.isRemote && this.ticksExisted > 5 && this.wasBombEaten()) {
            this.setDead();
            return;
        }
        Material material = this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ)).getMaterial();
        boolean bl = inFire = this.isBurning() || material == Material.lava || material == Material.fire || this.worldObj.func_147470_e(this.boundingBox);
        if (this.isDud(inFire)) {
            this.fuseTime += 10;
            this.disarm(this.worldObj);
        } else if (this.ticksExisted % 20 == 0) {
            this.playSound("zeldaswordskills:bomb_fuse", 1.0f, 2.0f + this.rand.nextFloat() * 0.4f);
        }
        if (!this.worldObj.isRemote && this.shouldExplode(inFire)) {
            CustomExplosion.createExplosion(this, this.worldObj, this.posX, this.posY, this.posZ, this.getRadius(), this.getDamage(), this.canGrief);
            this.setDead();
        }
    }

    private boolean wasBombEaten() {
        List entities = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.boundingBox.expand(0.5, 0.5, 0.5));
        for (EntityLivingBase entity : entities) {
            Event.Result result;
            if (!entity.isEntityAlive()) continue;
            Event.Result result2 = result = entity instanceof IEntityBombEater ? ((IEntityBombEater)entity).ingestBomb(this) : Event.Result.DENY;
            if (result == Event.Result.ALLOW) {
                return true;
            }
            if (result != Event.Result.DEFAULT || !ZSSEntityInfo.get(entity).onBombIngested(this)) continue;
            return true;
        }
        return false;
    }

    public boolean disarm(World world) {
        if (!world.isRemote && this.isEntityAlive() && this.fuseTime > 4) {
            this.setDead();
            EntityItem bomb = new EntityItem(world, this.posX, this.posY, this.posZ, new ItemStack(ZSSItems.bomb, 1, this.getType().ordinal()));
            bomb.delayBeforeCanPickup = 40;
            bomb.motionX = this.motionX;
            bomb.motionY = this.motionY;
            bomb.motionZ = this.motionZ;
            world.spawnEntityInWorld((Entity)bomb);
            return true;
        }
        return false;
    }

    protected void onImpact(MovingObjectPosition movingobjectposition) {
        this.motionX *= 0.5;
        this.motionY *= -0.5;
        this.motionZ *= 0.5;
    }

    private boolean isDud(boolean inFire) {
        switch (this.getType()) {
            case BOMB_WATER: {
                return inFire || this.worldObj.provider.isHellWorld;
            }
        }
        return this.worldObj.getBlock((int)this.posX, (int)this.posY, (int)this.posZ).getMaterial() == Material.water;
    }

    private boolean shouldExplode(boolean inFire) {
        if (!this.isEntityAlive()) {
            return false;
        }
        if ((inFire || this.worldObj.provider.isHellWorld) && this.getType() != BombType.BOMB_FIRE) {
            return true;
        }
        return this.ticksExisted >= this.fuseTime;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setByte("bombType", (byte)this.getType().ordinal());
        compound.setInteger("fuseTime", this.fuseTime);
        compound.setFloat("bombRadius", this.radius);
        compound.setFloat("motionFactor", this.motionFactor);
        compound.setFloat("destructionFactor", this.destructionFactor);
        compound.setBoolean("canGrief", this.canGrief);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.setType(BombType.values()[compound.getByte("bombType") % BombType.values().length]);
        this.fuseTime = compound.getInteger("fuseTime");
        this.radius = compound.getFloat("bombRadius");
        this.motionFactor = compound.getFloat("motionFactor");
        this.destructionFactor = compound.getFloat("destructionFactor");
        this.canGrief = compound.getBoolean("canGrief");
    }
}

